<?php
/* 
 * Copyright (C) 2013 ethicweb                  <infos@ethicweb.com>
 *
 */

/**
 *	\file       htdocs/prelevementSEPA/fiche.php
 */
// Dolibarr environment
$res = @include("../main.inc.php"); // From htdocs directory
if (! $res) {
    $res = @include("../../main.inc.php"); // From "custom" directory
	require_once DOL_DOCUMENT_ROOT.'/custom/relanceTiers/core/modules/relanceTiers/modules_relanceTiers.php';
}
else
{
	require_once DOL_DOCUMENT_ROOT.'/relanceTiers/core/modules/relanceTiers/modules_relanceTiers.php';
}
require_once DOL_DOCUMENT_ROOT.'/core/lib/company.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/bank.lib.php';
require_once DOL_DOCUMENT_ROOT.'/societe/class/companybankaccount.class.php';
require_once DOL_DOCUMENT_ROOT.'/core/class/html.formfile.class.php';


$langs->load("relanceTiers@relanceTiers");
$langs->load("pdfRelanceTiers@relanceTiers");
$langs->load("payment");
$langs->load("bank");
$langs->load("invoice");
$langs->load("withdrawals");

// Security check
$socid = isset($_GET["socid"])?$_GET["socid"]:'';
if ($user->societe_id) $socid=$user->societe_id;
$result = restrictedArea($user, 'societe','','');

$action = GETPOST('action','alpha');
$soc = new Societe($db);
$socid = $_GET["socid"];
$soc->fetch($socid);

function converToDoppleDecimal($var){
	if(strpos($var,".")===FALSE)return $var.".00";
	else if(strlen($var) - strpos($var,".") == 2)
	return $var."0";
	else if(strlen($var) - strpos($var,".") == 1)
	return $var."00";
	else return substr($var,0,strpos($var,'.')+3);
	
	}
	
function strcoupe($str,$pos){
	if ( strlen($str)>=$pos)
	{
		$str=substr($str,0,$pos);
		$pos=strrpos($str," ");
		$str=substr($str,0,$pos);
	
		return $str;
	}
	else return $str;
}
	

$datedeb=0;
$datefin=0;
if(isset($_POST['date1']))
{
	$datedeb=$_POST['date1'];
	$datefin=$_POST['date2'];	
}
else if(isset($_GET['date1']))
{
	$datedeb=$_GET['date1'];
	$datefin=$_GET['date2'];	
}
/*
 * Actions
 */
if (isset($_POST['niveauChange']) && isset($_POST['socid']))
{
	$sql='UPDATE llx_societe SET relance_lvl='.$_POST['niveauChange'].' WHERE rowid='.$_POST['socid'].';';
	$resql=$db->query($sql);
}
if (isset($_POST['niveauMaxChange']) && isset($_POST['socid']))
{
	$sql='UPDATE llx_societe SET relance_lvlmax='.$_POST['niveauMaxChange'].' WHERE rowid='.$_POST['socid'].';';
	$resql=$db->query($sql);
	$sql='UPDATE llx_societe SET relance_lvl=relance_lvlmax WHERE relance_lvl>relance_lvlmax AND rowid='.$_POST['socid'].';';
	$resql=$db->query($sql);
}
if (isset($_POST['contactChange']) && isset($_POST['socid']))
{
	$sql='UPDATE llx_societe SET contact_relance='.$_POST['contactChange'].' WHERE rowid='.$_POST['socid'].';';
	$resql=$db->query($sql);
}


if ( $action == 'confirm_delete' )
{
}
/*
 * Generate document
*/
else if ($action == 'builddoc')	// En get ou en post
{


	// Define output language
	$outputlangs = $langs;
	$newlang='';
	if ($conf->global->MAIN_MULTILANGS && empty($newlang) && GETPOST('lang_id')) $newlang=GETPOST('lang_id');
	if ($conf->global->MAIN_MULTILANGS && empty($newlang)) $newlang=$bon->client->default_lang;
	if (! empty($newlang))
	{
		$outputlangs = new Translate("",$conf);
		$outputlangs->setDefaultLang($newlang);
	}
	
	$result=relanceTiers_pdf_create($db, $soc, "crabe", $outputlangs, $hidedetails, $hidedesc, $hideref);
	if ($result <= 0)
	{
		dol_print_error($db,$result);
		exit;
	}
	else
	{
		//header('Location: '.$_SERVER["PHP_SELF"].'?socid='.$soc->id.(empty($conf->global->MAIN_JUMP_TAG)?'':'#builddoc'));
		//exit;
	}
}

/*
 * View
 */

$form = new Form($db);

llxHeader('');
$head = societe_prepare_head($soc);
dol_fiche_head($head, 'tiers_recap_invoice', $langs->trans("ThirdParty"),0,'company');

$depart_date=false;

if ($socid > 0)
{


	if (GETPOST('error','alpha')!='') 
	{
		print '<div class="error"></div>';
	}
		
	$sql="SELECT 
	nom,
	SUM(amount) as som,
	relance_lvl,
	relance_total,
	date_relance,
	max(if(paye=0,DATEDIFF(CURDATE(),date),0)) as retard,
	max(dateprel) as lastprel,
	sum(if(fac=1 and paye=0,1,0)) as nb_non_paye,
	socid,
	contact_relance,
	email,
	relance_lvlmax
	FROM(
	SELECT 
		f.total_ttc*(-1) as amount,
		f.paye,
    	1 as fac,
		f.date_lim_reglement as date,
		\"0000-00-00\" as dateprel,
		s.rowid as socid,
		s.nom as nom,
		s.date_relance,
		s.relance_lvl,
				s.email,
		s.contact_relance,
		s.relance_total,
			s.relance_lvlmax,
			f.rowid
			FROM `llx_societe` s 
			inner join llx_facture f on f.fk_soc=s.rowid 
								WHERE s.rowid=".$socid."
			AND (f.fk_statut=1 OR f.fk_statut=2)
								AND f.total_ttc > 0 
		UNION ALL
		
	SELECT 
		pf.amount,
		f.paye,
    	0 as fac,
		f.date_lim_reglement as date, 
		p.datep as dateprel, 
		s.rowid as socid,
		s.nom as nom,
		s.date_relance,
		s.relance_lvl,
		s.relance_total,
		s.contact_relance,
			s.relance_lvlmax,
		s.email,
			p.rowid
			FROM `llx_societe` s 
			inner join llx_facture f on f.fk_soc=s.rowid 
			inner join llx_paiement_facture pf on  pf.fk_facture=f.rowid 
			inner join llx_paiement p on pf.fk_paiement=p.rowid 
		WHERE s.rowid=".$socid."
			AND (f.fk_statut=1 OR f.fk_statut=2)
	UNION ALL
	
		SELECT 
			f.total_ttc*(-1) as amount,
			1 AS paye,
			3 as fac,
			f.datef as date,
			\"0000-00-00\" as dateprel,
			s.rowid as socid,
			s.nom as nom,
			s.date_relance,
			s.relance_lvl,
					s.email,
			s.contact_relance,
			s.relance_total,
			s.relance_lvlmax,
			f.rowid
				FROM `llx_societe` s 
				inner join llx_facture f on f.fk_soc=s.rowid 
				WHERE s.rowid=".$socid."
			AND (f.fk_statut=1 OR f.fk_statut=2)
			AND f.total_ttc < 0 
		UNION ALL
		SELECT 
			r.amount_ttc as amount,
			1 as paye,
			3 as fac,
			r.datec as date,
			\"0000-00-00\" as dateprel,
			s.rowid as socid,
			s.nom as nom,
			s.date_relance,
			s.relance_lvl,
					s.email,
			s.contact_relance,
			s.relance_total,
			s.relance_lvlmax,
			r.rowid
			
				FROM `llx_societe` s 
				inner join llx_societe_remise_except r on s.rowid=r.fk_soc
				WHERE s.rowid=".$socid."
			AND r.fk_facture IS NULL
				AND r.fk_facture_line IS NULL
				AND r.fk_facture_source IS NULL
	) as a
	JOIN (SELECT @csum := 0) b
	GROUP BY socid";
	$resql=$db->query($sql);
	if ($resql)
	{
		$num = $db->num_rows($resql);
		if ($num)
		{
			$row = $db->fetch_row($resql);

			print '<table class="border" width="100%">';

			print '<tr><td width="20%">'.$langs->trans('NomTiers').'</td><td>'.$row[0].'</td></tr>';
			
			if($row[5]<=0)$str_date5=$langs->trans("NoLate");
				else
				{
					$str_date5=$row[5].' '.$langs->trans("jour").'(s)';
				}
			print '<tr><td width="20%">'.$langs->trans("Retard").'</td><td>'.$str_date5.'</td></tr>';
			
			if($row[4]==null)$str_date4="NC";
					else
					{
						$date4=new DateTime($row[4]);
						if($date4->format('Y') >2099 || $date4->format('Y') < 1980)
						$str_date4="NC";else $str_date4=$date4->format('d/m/Y');
					}
			print '<tr><td width="20%">'.$langs->trans("DerniereRelance").'</td><td>'.$str_date4.'</td></tr>';
			
			if($row[5]==0){
			
				$sql_not_late="UPDATE llx_societe SET relance_lvl=1 WHERE rowid =".$socid;
				$resql_not_late=$db->query($sql_not_late);
				$row[2]=1;
			}
			
			print '<tr><td width="20%">'.$langs->trans("Niveau").'</td><td>
			<form method=POST action="">
			
				<input type="hidden" name="socid" value="'.$socid.'">
				<select name="niveauChange" '.($row[5]==0?'disabled':'').'>';
				for($i=1;$i<=$row[11];$i++)
				{
					print '<OPTION '.($row[2]==$i?'selected':'').'>'.$i.'</OPTION>';
				}
				print'</select>
				<input type="submit" value="'.$langs->trans("Modifier").'" '.($row[5]==0?'disabled title="'.$langs->trans("NoLate").'"':'').'>
			</form>
			</td></tr>';
			
			print '<tr><td width="20%">'.$langs->trans("NiveauMax").'</td><td>
			<form method=POST action="">
			
				<input type="hidden" name="socid" value="'.$socid.'">
				<select name="niveauMaxChange" >				
					<OPTION '.($row[11]==1?'selected':'').'>1</OPTION>
					<OPTION '.($row[11]==2?'selected':'').'>2</OPTION>
					<OPTION '.($row[11]==3?'selected':'').'>3</OPTION>
				</select>
				<input type="submit" value="'.$langs->trans("Modifier").'" >
			</form>
			</td></tr>';
			
			print '<tr><td width="20%">'.$langs->trans("ContactRelance").'</td><td>
			<form method=POST action="">
			
				<input type="hidden" name="socid" value="'.$socid.'">
				<select name="contactChange">
					<OPTION '.($row[9]==0?'selected':'').' value="0">'.$langs->trans("ContactSoc").' ( @mail : '.$row[10].' ) </OPTION>';
				
				$sqlcontact='SELECT rowid,firstname,lastname,email FROM llx_socpeople WHERE fk_soc='.$socid.';';
				$resqlcontact=$db->query($sqlcontact);
				if ($resqlcontact)
				{
					$numcontact = $db->num_rows($resqlcontact);
					if ($numcontact)
					{
						$icontact = 0;
						while ($icontact < $numcontact)
						{
							$rowcontact = $db->fetch_row($resqlcontact);
							print '<OPTION '.($row[9]==$rowcontact[0]?'selected':'').' value="'.$rowcontact[0].'">'.$rowcontact[1].' '.$rowcontact[2].' ( @mail : '.$rowcontact[3].' ) </OPTION>';
							$icontact++;
						}
					}
				}
				print '</select>
				<input type="submit" value="'.$langs->trans("Modifier").'">
			</form>
			</td></tr>';
			
			
			print '<tr><td width="20%">'.$langs->trans("Solde").'</td><td>'.converToDoppleDecimal($row[1]).' '.$conf->currency.'</td>';
			
			print '<tr><td width="20%">'.$langs->trans("NbFac").'</td><td>'.$row[7].'</td>';
			
			if($row[6]==null)$str_date6="NC";
					else
					{
						$date6=new DateTime($row[6]);
						if($date6->format('Y') >2099 || $date6->format('Y') < 1980)
						$str_date6="NC";else $str_date6=$date6->format('d/m/Y');
					}
			print '<tr><td width="20%">'.$langs->trans("DateDernierPaiement").'</td><td>'.$str_date6.'</td></tr>';

		

			print '</table>';
				print '<p>'.$langs->trans("RetardExplication").'</p>';
			print '<br />';
			print '<a href="'.DOL_URL_ROOT.(file_exists(DOL_DOCUMENT_ROOT.'/relanceTiers')?'':'/custom').'/relanceTiers/relance_tiers.php">'.$langs->trans("VoirListe").'</a>';
			print '<br />';
			
			dol_fiche_end();
			
			print '<div style="text-align:center;">
			<form method="post" action="societe_fiche.php?socid='.$socid.'&action=view">
			'.$langs->trans("VoirPaiementFacDu");
			$form->select_date(($datedeb!=0?DateTime::createFromFormat('d/m/Y',$datedeb)->format("Y-m-d"):''),'date1',0,0,'',"contrat");
			 print ' '.$langs->trans("Au").' ';
			 
			 $f = ($datefin!=0?DateTime::createFromFormat('d/m/Y',$datefin)->format("Y-m-d"):'');
			 
			$form->select_date(($datefin!=0?DateTime::createFromFormat('d/m/Y',$datefin)->format("Y-m-d"):''),'date2',0,0,'',"contrat");
			 print ' <input type="submit" value="OK">
			</form>
			</div>';
		
		
			if($datedeb!=0){
				print '<div class="titre">'.$langs->trans("PaiementComprisEntre").' '.$datedeb.$langs->trans("EtLe").$datefin.' : </div>';
			}
			else
			print '<div class="titre">'.$langs->trans("TenLasts").' </div>';
			
			
			print '<table class="liste" border="1 px solid">';
			print '<tr class="liste_titre">';
			print '<td>'.$langs->trans("Titre").'</td>';
			print '<td>'.$langs->trans("Date").'</td>';
			print '<td>'.$langs->trans("Date Limite Régl. (Facture)").'</td>';
			print '<td>'.$langs->trans("Debit").'</td>';
			print '<td>'.$langs->trans("Credit").'</td>';
			print '<td>'.$langs->trans("SoldeCum").'</td>';
			print '</tr>';
			
			$sql= "SELECT 
			title, date, debit, credit, (@csum := @csum + amount)as solde,label,paye,datelim FROM(
			SELECT 
			CONCAT(\"".$langs->trans("Paiement")." ( \",ty.code,\" ) sur \",f.facnumber,\" : \",p.num_paiement,\"-\") as title,
			p.datec as date,
			IF(pf.amount<0,round(pf.amount*(-1),2),'' )as debit,
			IF(pf.amount>0,round(pf.amount,2),'') as credit,round(pf.amount,2) as amount,
			b.label,
			1 as paye,
			\"\" as datelim
			FROM `llx_societe` s 
			inner join llx_facture f on f.fk_soc=s.rowid 
			inner join llx_paiement_facture pf on  pf.fk_facture=f.rowid 
			inner join llx_paiement p on pf.fk_paiement=p.rowid 
			inner join llx_c_paiement ty on ty.id=p.fk_paiement 
			inner join llx_bank b on b.rowid=p.fk_bank 
			WHERE s.rowid=".$socid." 
			AND (f.fk_statut=1 OR f.fk_statut=2)
			UNION ALL
			
			SELECT 
			
				CONCAT(\"".$langs->trans("Facture")." : \",f.facnumber) as title,
				f.datef as date,
				IF(f.total_ttc>0,round(f.total_ttc,2),'' )as debit,
				IF(f.total_ttc<0,round(f.total_ttc*(-1),2),'') as credit,
				round(f.total_ttc*(-1),2) as amount,
				\"\" as label,f.paye,
			f.date_lim_reglement as datelim
			FROM `llx_societe` s 
			inner join llx_facture f on f.fk_soc=s.rowid 
			WHERE s.rowid=".$socid."
			AND (f.fk_statut=1 OR f.fk_statut=2)
			AND f.total_ttc >0
			
			UNION ALL
			
			SELECT 
			
				CONCAT(\"".$langs->trans("Avoir")." : \",f.facnumber) as title,
				f.datef as date,
				IF(f.total_ttc>0,round(f.total_ttc,2),'' )as debit,
				IF(f.total_ttc<0,round(f.total_ttc*(-1),2),'') as credit,
				round(f.total_ttc*(-1),2) as amount,
				\"\" as label,1 as paye,
			\"\" as datelim
			FROM `llx_societe` s 
			inner join llx_facture f on f.fk_soc=s.rowid 
			WHERE s.rowid=".$socid."
			AND (f.fk_statut=1 OR f.fk_statut=2)
			AND f.total_ttc <0
			
			UNION ALL
			
			SELECT 
			
			CONCAT(\"".$langs->trans("Remise")." : \",r.description) as title,
			r.datec as date,
			IF(r.amount_ttc<0,round(r.amount_ttc*(-1),2),'' )as debit,
			IF(r.amount_ttc>0,round(r.amount_ttc,2),'') as credit,
			round(r.amount_ttc,2) as amount,
			\"\" as label, 1 as paye,
			\"\" as datelim
				FROM `llx_societe` s 
				inner join llx_societe_remise_except r on s.rowid=r.fk_soc
				WHERE s.rowid=".$socid."
				AND r.fk_facture IS NULL
				AND r.fk_facture_line IS NULL
				AND r.fk_facture_source IS NULL
			) as a 
			JOIN (SELECT @csum := 0) b
			order by date;";
			$liste =array();
			$cumul =array();
			$depart=-1;
			$fin=-1;
			$pardate=false;

			if($datedeb!=0){
				 $ddeb=DateTime::createFromFormat('d/m/Y',$datedeb);
				 $dfin=DateTime::createFromFormat('d/m/Y',$datefin);
				 
				 $pardate=true;
			}

			
			$resql=$db->query($sql);
			if ($resql)
			{
				$num = $db->num_rows($resql);
				if ($num)
				{
					$i = 0;
					while ($i < $num)
					{
						$row = $db->fetch_row($resql);
						$cumul[$i]=$row[4];
								$type=$row[5];
								$type=str_replace(array("(",")"),array("",""),$type);
								$type=$langs->trans($type);
								$descr=strcoupe($row[0].$type,100);	
						if($row[6]=="0")
						$liste[$i]='<tr style="color:red;">';
						else
						$liste[$i]='<tr>';
						
						$liste[$i].='<td>'.$descr.'</td><td>';
							$d=new DateTime($row[1]);
							$str_d=$d->format('d/m/Y');
						$liste[$i].=$str_d.'</td><td>';
						if($row[7]!="" && $row[7]!=null){
								$d=new DateTime($row[7]);
								
								$str_d=$d->format('d/m/Y');
							$liste[$i].=$str_d;
						}
						$liste[$i].='</td>';
						
						$liste[$i].='<td style="text-align:right;">'.$row[2].($row[2]!=null?' '.$conf->currency.'':'').'</td>
						<td style="text-align:right;">'.$row[3].($row[3]!=null?' '.$conf->currency.'':'').'</td>
						<td style="text-align:right;">'.$row[4].' '.$conf->currency.'</td>
						</tr>';
						if($pardate){
							$comp=new DateTime($row[1]);								
							if($depart==-1 && $comp >= $ddeb)$depart=$i;
							if($fin ==-1 && $depart!=-1 && $comp > $dfin)$fin=$i-1;
						}
						$i++;
					}
				}
			}
						
			if($depart==-1)
			{
				if($pardate) $depart=$i;
				else $depart=$i-10;
				
			}
			if($depart<0)$depart=0;
			if($fin==-1){
				if($pardate) $fin =$i-1;
				else $fin=$depart+9;
			}
			if($fin>=$i)$fin=$i-1;


			if($depart !=0) print '<tr>
			<td>'.$langs->trans("SoldePrec").'</td>
			<td></td>
			<td></td>
			<td></td>
			<td></td>
			<td style="text-align:right;">'.$cumul[$depart-1].' '.$conf->currency.'</td>
			</tr>';
			for($j=$depart;$j<=$fin;$j++)
				print $liste[$j];
						
			print '</table><br/>En rouge sont les factures non-payées.';
			print '<br/><br/>';
			
			
			// List of actions on element
			
			//include_once DOL_DOCUMENT_ROOT.(file_exists(DOL_DOCUMENT_ROOT.'/relanceTiers')?'':'/custom').'/relanceTiers/class/html.formfile.class.php';


			$formfile = new FormFile($db);
			// Documents generes
			$filename=$socid;
			$filedir=DOL_DATA_ROOT.'/relanceTiers/receipts/'.$socid.'/';
			$urlsource=$_SERVER['PHP_SELF'].'?socid='.$socid.($datedeb!=0?'&date1='.$datedeb.'&date2='.$datefin:'');
			$genallowed=$user->rights->facture->creer;
			$delallowed=$user->rights->facture->supprimer;
			print $formfile->showdocuments('relancetiers',$filename,$filedir,$urlsource,$genallowed,$delallowed,'',1,0,0,28,0,'','','','');
			$somethingshown=$formfile->numoffiles;
	
		}
			else
		{
			$sql2="SELECT 
		nom,
		0,
		relance_lvl,
    	relance_total,
		date_relance, 
		\"".$langs->trans("NoLate")."\", 
		null,
		0,
		rowid,
		contact_relance,
		email,
		relance_lvlmax
			FROM `llx_societe` 
		WHERE rowid=".$socid;
			$resql=$db->query($sql2);
			if ($resql)
			{
				$row = $db->fetch_row($resql);
			
				
				print '<table class="border" width="100%">';

				print '<tr><td width="20%">'.$langs->trans('NomTiers').'</td><td>'.$row[0].'</td></tr>';
				
						$str_date5=$row[5];
				print '<tr><td width="20%">'.$langs->trans("Retard").'</td><td>'.$str_date5.'</td></tr>';
				
				if($row[4]==null)$str_date4="NC";
						else
						{
							$date4=new DateTime($row[4]);
							if($date4->format('Y') >2099 || $date4->format('Y') < 1980)
							$str_date4="NC";else $str_date4=$date4->format('d/m/Y');
						}
				print '<tr><td width="20%">'.$langs->trans("DerniereRelance").'</td><td>'.$str_date4.'</td></tr>';
				
				
				print '<tr><td width="20%">'.$langs->trans("Niveau").'</td><td>
				<form method=POST action="">
				
					<input type="hidden" name="socid" value="'.$socid.'">
					<select name="niveauChange" '.($row[5]==0?'disabled':'').'>';
					for($i=1;$i<=$row[11];$i++)
					{
						print '<OPTION '.($row[2]==$i?'selected':'').'>'.$i.'</OPTION>';
					}
					print'</select>
					<input type="submit" value="'.$langs->trans("Modifier").'" disabled title="'.$langs->trans("NoLate").'">
				</form>
				</td></tr>';
				
				print '<tr><td width="20%">'.$langs->trans("NiveauMax").'</td><td>
				<form method=POST action="">
				
					<input type="hidden" name="socid" value="'.$socid.'">
					<select name="niveauMaxChange" >				
						<OPTION '.($row[11]==1?'selected':'').'>1</OPTION>
						<OPTION '.($row[11]==2?'selected':'').'>2</OPTION>
						<OPTION '.($row[11]==3?'selected':'').'>3</OPTION>
					</select>
					<input type="submit" value="'.$langs->trans("Modifier").'" >
				</form>
				</td></tr>';
				
				print '<tr><td width="20%">'.$langs->trans("ContactRelance").'</td><td>
				<form method=POST action="">
				
					<input type="hidden" name="socid" value="'.$socid.'">
					<select name="contactChange">
						<OPTION '.($row[9]==0?'selected':'').' value="0">'.$langs->trans("ContactSoc").' ( @mail : '.$row[10].' ) </OPTION>';
					
					$sqlcontact='SELECT rowid,firstname,lastname,email FROM llx_socpeople WHERE fk_soc='.$socid.';';
					$resqlcontact=$db->query($sqlcontact);
					if ($resqlcontact)
					{
						$numcontact = $db->num_rows($resqlcontact);
						if ($numcontact)
						{
							$icontact = 0;
							while ($icontact < $numcontact)
							{
								$rowcontact = $db->fetch_row($resqlcontact);
								print '<OPTION '.($row[9]==$rowcontact[0]?'selected':'').' value="'.$rowcontact[0].'">'.$rowcontact[1].' '.$rowcontact[2].' ( @mail : '.$rowcontact[3].' ) </OPTION>';
								$icontact++;
							}
						}
					}
					print '</select>
					<input type="submit" value="'.$langs->trans("Modifier").'">
				</form>
				</td></tr>';
				
				
				print '<tr><td width="20%">'.$langs->trans("Solde").'</td><td>'.converToDoppleDecimal($row[1]).' '.$conf->currency.'</td>';
				print '<tr><td width="20%">'.$langs->trans("NbFac").'</td><td>'.$row[7].'</td>';
				
				if($row[6]==null)$str_date6="NC";
						else
						{
							$date6=new DateTime($row[6]);
							if($date6->format('Y') >2099 || $date6->format('Y') < 1980)
							$str_date6="NC";else $str_date6=$date6->format('d/m/Y');
						}
				print '<tr><td width="20%">'.$langs->trans("DateDernierPaiement").'</td><td>'.$str_date6.'</td></tr>';
			

				print '</table>';
				print '<p>'.$langs->trans("RetardExplication").'</p>';
				print '<br />';
				print '<a href="'.DOL_URL_ROOT.(file_exists(DOL_DOCUMENT_ROOT.'/relanceTiers')?'':'/custom').'/relanceTiers/relance_tiers.php">'.$langs->trans("VoirListe").'</a>';
				print '<br />';
				
				dol_fiche_end();
				print '<p>'.$langs->trans("NoTransac").'</p>';
			
			
			}
		}
	}	
}




	// Actions
	if ($action != 'settransmitted' && $action != 'setcredited')
	{
		
	}
	if ($action != 'prerelance' && $action != 'presend')
	{
				
	}
llxFooter();

$db->close();
?>
