<?php
/* 
 * Copyright (C) 2013 ethicweb                  <infos@ethicweb.com>
 *
 */

/**
 *	\file       htdocs/prelevementSEPA/fiche.php
 */
// Dolibarr environment
$res = @include("../main.inc.php"); // From htdocs directory
if (! $res) {
    $res = @include("../../main.inc.php"); // From "custom" directory
	require_once DOL_DOCUMENT_ROOT.'/custom/relanceTiers/core/modules/relanceTiers/modules_relanceTiers.php';
}
else
{
	require_once DOL_DOCUMENT_ROOT.'/relanceTiers/core/modules/relanceTiers/modules_relanceTiers.php';
}
require_once DOL_DOCUMENT_ROOT.'/core/lib/company.lib.php';
require_once DOL_DOCUMENT_ROOT.'/core/lib/bank.lib.php';
require_once DOL_DOCUMENT_ROOT.'/societe/class/companybankaccount.class.php';

dol_include_once('/relanceTiers/class/relancearchive.class.php');


$langs->load("recapPaiement@relanceTiers");
$langs->load("pdfRelanceTiers@relanceTiers");
$langs->load("payment");
$langs->load("bank");
$langs->load("invoice");
$langs->load("withdrawals");

// Security check
// Security check
$socid = isset($_GET["socid"])?$_GET["socid"]:'';
if ($user->societe_id) $socid=$user->societe_id;
$result = restrictedArea($user, 'societe','','');

$action = GETPOST('action','alpha');
$soc = new Societe($db);
$socid = $_GET["socid"];
$soc->fetch($socid);

/*******************************************************************
* ACTIONS
********************************************************************/

if ($action === 'add')
{
	$date_relancemonth=GETPOST('date_relancemonth');
	$date_relanceday=GETPOST('date_relanceday');
	$date_relanceyear=GETPOST('date_relanceyear');
	$date_relance=dol_mktime(0, 0, 0, $date_relancemonth, $date_relanceday, $date_relanceyear);
	
	$type_relance=GETPOST('type_relance', 'alpha');
	$niveau_relance=GETPOST('niveau_relance', 'int');
	$description_relance=GETPOST('description_relance', 'alpha');


	$object=new Relancearchive($db);
	$object->date_relance=$date_relance;
	$object->type_relance=$type_relance;
	$object->niveau_relance=$niveau_relance;
	$object->description=$description_relance;
	$object->fk_soc = $socid;

	$result=$object->create($user);	
	if ($result > 0)
	{
		$_SESSION['dol_events']['mesgs'][] = $langs->trans("relanceArchiveCreateOk", $filename);
		//redirect after saving to prevent re-submission of the form on refresh
		header('Location: '.htmlentities($_SERVER['PHP_SELF']).'?'.http_build_query(array('socid' => $socid, 'mainmenu' => 'home')));
		exit;
	} 
	else
	{
		$_SESSION['dol_events']['errors'][] = $object->error;
	}
}

if($action === 'exportPdf') {
	$result=relanceTiers_pdf_createarchive($db, $soc, "relanceArchive", $outputlangs, $hidedetails, $hidedesc, $hideref);
	if ($result <= 0)
	{
		dol_print_error($db,$result);
		exit;
	} else {
		header('Location:document.php?modulepart=relanceArchives&file=relance_archive_'.$soc->id.'.pdf');
	}
} else if ($action === 'exportTxt') {
	$dir = DOL_DATA_ROOT."/relanceTiers/temp/".$soc->id;
	$file = $dir . "/relance_archive_" . $soc->id . ".txt";

	if (! file_exists($dir))
	{
		if (dol_mkdir($dir) < 0)
		{
			$this->error=$langs->transnoentities("ErrorCanNotCreateDir",$dir);
			return 0;
		}
	}
	else
	{
		$handle = fopen($file, 'w');
		if(is_resource($handle) === true)
		{

			fwrite($handle, $langs->trans("HistoriqueDesRelances")."\r\n");
			fwrite($handle, $langs->trans('Date').";".$langs->trans('NiveauRelance').";".$langs->trans('TypeRelance').";".$langs->trans('Description')."\r\n");

			$sql = "SELECT t.rowid,t.fk_soc,t.date_relance,t.type_relance,t.niveau_relance,t.description
			FROM ".MAIN_DB_PREFIX."relance_archive as t
			WHERE t.fk_soc='$socid'";

			$resql=$db->query($sql);
			if ($resql)
			{
			    $num = $db->num_rows($resql);
			    $i = 0;
			    if ($num)
			    {
			        while ($i < $num)
			        {
			            $obj = $db->fetch_object($resql);
			            if ($obj)
			            {
			                fwrite($handle, $obj->date_relance.";".$obj->niveau_relance.";".html_entity_decode($obj->type_relance).";".$obj->description."\r\n");
			            }
			            $i++;
			        }
			    }
			}
			else
			{
			    $error++;
			    dol_print_error($db);
			}
			fclose($handle);

			header('Location:document.php?modulepart=relanceArchives&file=relance_archive_'.$soc->id.'.txt');
		}

	}
}

/***************************************************
* VIEW
****************************************************/

llxHeader('',$langs->trans('RelanceArchives'),'');
$form=new Form($db);

$head = societe_prepare_head($soc);
dol_fiche_head($head, 'tiers_recap_archives', $langs->trans("ThirdParty"),0,'company');

?>
<form action="<?php echo htmlentities($_SERVER['PHP_SELF']).'?socid='.$socid;?>" method="POST">
	<input type="hidden" name="action" value="add"/>
	<fieldset>
		<legend><?php echo $langs->trans('AddRelanceManually')?></legend>
		<table class="border" width="100%">
			<tr>
				<td></td>
				<td></td>
			</tr>
			<tr>
				<td><?php echo $langs->trans('AddDateRelance')?></td>
				<td><?php print $form->select_date($date_relance,'date_relance',0,0,0,'',1,0,1)?></td>
			</tr>
			<tr>
				<td><?php echo $langs->trans('AddTypeRelance')?></td>
				<td><input type="text" name="type_relance" value="<?php echo $type_relance?>"/></td>
			</tr>
			<tr>
				<td><?php echo $langs->trans('AddNiveauRelance')?></td>
				<td><input type="number" name="niveau_relance" value="<?php echo $niveau_relance?>" maxlength="2"/></td>
			</tr>
			<tr>
				<td><?php echo $langs->trans('AddDescriptionRelance')?></td>
				<td><textarea name="description_relance"><?php echo $description_relance?></textarea></td>
			</tr>
			<tr>
				<td colspan="2" align="right"><input type="submit"/></td>
			</tr>
		</table>
	</fieldset>
</form>
<?php 

$sql = "SELECT";
$sql.= " t.rowid,";

	$sql.= " t.fk_soc,";
	$sql.= " t.date_relance,";
	$sql.= " t.type_relance,";
	$sql.= " t.niveau_relance,";
	$sql.= " t.description";


$sql.= " FROM ".MAIN_DB_PREFIX."relance_archive as t";
$sql.= " WHERE t.fk_soc='$socid'";

print '<table class="noborder" width="100%">'."\n";
print '<tr class="liste_titre">';
//print_liste_field_titre($langs->trans('fk_soc'),$_SERVER['PHP_SELF'],'t.fk_soc','',$param,'',$sortfield,$sortorder);
print_liste_field_titre($langs->trans('date_relance'),$_SERVER['PHP_SELF'],'t.date_relance','',$param,'',$sortfield,$sortorder);
print_liste_field_titre($langs->trans('type_relance'),$_SERVER['PHP_SELF'],'t.type_relance','',$param,'',$sortfield,$sortorder);
print_liste_field_titre($langs->trans('niveau_relance'),$_SERVER['PHP_SELF'],'t.niveau_relance','',$param,'',$sortfield,$sortorder);
print_liste_field_titre($langs->trans('description'),$_SERVER['PHP_SELF'],'t.description','',$param,'',$sortfield,$sortorder);
print '</tr>';

dol_syslog($script_file." sql=".$sql, LOG_DEBUG);
$resql=$db->query($sql);
if ($resql)
{
    $num = $db->num_rows($resql);
    $i = 0;
    if ($num)
    {
        while ($i < $num)
        {
            $obj = $db->fetch_object($resql);
            if ($obj)
            {
                // You can use here results
                print '<tr>';
                //print '<td>'.$obj->fk_soc.'</td>';
                print '<td>'.$obj->date_relance.'</td>';
                print '<td>'.$obj->type_relance.'</td>';
                print '<td>'.$obj->niveau_relance.'</td>';
                print '<td>'.$obj->description.'</td>';
                print '</tr>';
            }
            $i++;
        }
    }
}
else
{
    $error++;
    dol_print_error($db);
}

print '</table>'."\n";

?>
<form action="<?php echo htmlentities($_SERVER['PHP_SELF']).'?socid='.$socid;?>" method="POST">
	<input type="hidden" name="action" value="exportPdf"/>
	<input type="submit" value="<?php echo $langs->trans('ExportRelanceArchivePdf');?>"/>
</form>
<form action="<?php echo htmlentities($_SERVER['PHP_SELF']).'?socid='.$socid;?>" method="POST">
	<input type="hidden" name="action" value="exportTxt"/>
	<input type="submit" value="<?php echo $langs->trans('ExportRelanceArchiveTxt');?>"/>
</form>
<?php

dol_htmloutput_events();

// End of page
llxFooter();
$db->close();