<?

/*
 * Script quotidien de création / mise à jour des dossiers de recouvrement
 */

require('../config.php');
dol_include_once("/recouvrement/class/dossier.class.php");
dol_include_once("/compta/facture/class/facture.class.php");

$ATMdb = new TPDOdb();

/*
 * ETAPE 1 : Création des nouveaux dossiers
 */
// Récupération des factures impayées non déjà associées à un dossier en cours
$sql = "SELECT f.rowid ";
$sql.= "FROM ".MAIN_DB_PREFIX."facture f ";
$sql.= "LEFT JOIN ".MAIN_DB_PREFIX."rec_dossier_facture rdf ON rdf.fk_facture = f.rowid ";
$sql.= "WHERE f.entity = ".$conf->entity." ";
$sql.= "AND f.fk_statut = 1 ";
$sql.= "AND rdf.fk_dossier IS NULL ";
$sql.= "AND f.date_lim_reglement < NOW() ";
$sql.= "AND f.paye = 0";

$TIdFacture = TRequeteCore::_get_id_by_sql($ATMdb, $sql);

foreach ($TIdFacture as $idFacture) {
	$fact = new Facture($db);
	$fact->fetch($idFacture);
	$doss = new TRecDossier();
	
	if(!$doss->loadBy($ATMdb, $fact->socid, 'fk_soc')) {
		$doss->entity = $conf->entity; // TODO : notion entity ? 2 dossiers dans 2 entity pour un même client ?
		$doss->fk_soc = $fact->socid;
	}

	if (empty($doss->fk_user)) {
		// Par défaut on affecte le dossier au commercial rattaché à la société
		$societe = new Societe($db);
		$societe->fetch($fact->socid);
		
		$TCommerciaux = $societe->getSalesRepresentatives($user);

		if (!empty($TCommerciaux)) {
			$doss->fk_user = $TCommerciaux[0]['id'];
		}	
	}

	// On défini la procédure standard par défaut
	if (empty($doss->fk_procedure)) {
		$doss->fk_procedure = 1;
	}
	
	// On passe à la première étape si aucune déjà faite
	if (empty($doss->fk_etape)) {
		$doss->fk_etape = 1;
	}
	
	//var_dump($doss); exit;
	$doss->addFacture($idFacture);
	$doss->save($ATMdb);
	
	$doss->etape->load($ATMdb,$doss->fk_etape);

	$doss->doAction($user, $ATMdb);
	$doss->save($ATMdb);
	//var_dump($doss); exit;
}


// ETAPE 2 : Récupération des factures associées à un dossier en cours et qui ne sont plus impayées
$sql = "SELECT f.rowid ";
$sql.= "FROM ".MAIN_DB_PREFIX."facture f ";
$sql.= "LEFT JOIN ".MAIN_DB_PREFIX."rec_dossier_facture rdf ON rdf.fk_facture = f.rowid ";
$sql.= "LEFT JOIN ".MAIN_DB_PREFIX."rec_dossier rd ON rd.rowid = rdf.fk_dossier ";
$sql.= "WHERE f.fk_statut > 1 ";
$sql.= "AND rd.statut = 'EN_COURS' ";
