<?php
// Chargement de la configuration
require '../config.php';
dol_include_once('/compta/facture/class/facture.class.php');
dol_include_once('/recouvrement/class/procedure.class.php');
dol_include_once('/recouvrement/class/dossier.class.php');
dol_include_once('/recouvrement/class/etape.class.php');

$PDOdb = new TPDOdb;

// Recherche procédure par défaut OU première procédure définie
$default_proc = _getDefaultProcedure($PDOdb);

if ($default_proc !== false) {
	// On récupère la première étape
	$etape = $default_proc->TRecEtape[0];
	$delai = $etape->delais;
	
	// Recherche factures impayées depuis plus de X jours
	$TFactures = _getFacturesImpayees($PDOdb, $delai);

	// Construction du tableau de données selon la structure attendue par la fonction _attribFacture
	$TDonnees = array(
		'TProcedure' => array()
	);

	if (!empty($TFactures)) {
		foreach ($TFactures as $facture) {
			$TDonnees['TProcedure'][$facture->rowid] = $default_proc->getId();
		}
		
		// Traitement
		_attribFacture($PDOdb, $TDonnees);
	} else {
		setEventMessage('Aucune facture impayée à recouvrer.');	
	}
} else {
	setEventMessage('Vous devez auparavant définir une procédure par défaut à appliquer.', 'errors');
}

header('Location: ' . dol_buildpath('/recouvrement/admin/configuration.php', 1));
exit;

function _getDefaultProcedure(&$PDOdb) {
	$default_proc = new TRecProcedure;
	$default_proc->loadBy($PDOdb, 1, 'is_default');
	
	if ($default_proc->rowid > 0) {
		return $default_proc;
	} else {
		return false;
	}
}

function _getFacturesImpayees(&$PDOdb, $delai) {
	global $db;
	
	$TFactures = array();
	
	$sql = '
		SELECT rowid
		FROM ' . MAIN_DB_PREFIX . 'facture
		WHERE paye = 0
		AND fk_statut = 1
		AND NOW() > DATE_ADD(date_lim_reglement, INTERVAL ' . $delai . ' DAY)
		AND rowid NOT IN (
			SELECT f.fk_facture
			FROM ' . MAIN_DB_PREFIX . 'rec_dossier_facture as f
			INNER JOIN ' . MAIN_DB_PREFIX . 'rec_dossier as d ON d.rowid = f.fk_dossier
			WHERE d.statut = "OPEN"
		)
	';
	
	$TResultats = $PDOdb->ExecuteAsArray($sql);
	
	return $TResultats;
}

