<?php
	require('config.php');
	dol_include_once('/projet/class/project.class.php');
	dol_include_once('/projet/class/task.class.php');
	dol_include_once('/user/class/user.class.php');
	dol_include_once('/core/lib/usergroups.lib.php');
	
	
	
	llxHeader('',$langs->trans('GraphFacturation'));
	
	
	
	
	print dol_get_fiche_head($langs->trans('GraphFacturation'));
	print_fiche_titre($langs->trans("Histogramme de facturation"));
	
	_print_filtres();
	_print_graph();
	
	
	function _print_graph(){
		global $langs;
		
		$date_d=str_replace('/', '-', GETPOST('date_deb'));
		$date_f=str_replace('/', '-', GETPOST('date_fin'));
		$date_deb=date('Y-m-d', strtotime($date_d));
		$date_fin=date('Y-m-d', strtotime($date_f));
		
		$getPost_date_deb = GETPOST('date_deb');
		$getPost_date_fin = GETPOST('date_fin');
		
		if(empty($getPost_date_deb))$date_deb=date('Y-m-d', strtotime(date('Y-m-d'))-(60*60*24*365));
		if(empty($getPost_date_fin))$date_fin=date('Y-m-d');
		
		

		$TData = array();
		$TFacture = _get_montant_factures($date_deb, $date_fin);

		$PDOdb = new TPDOdb;

		//TODO reformater le tableau 
		foreach ($TFacture as $facture) {
			$TData[] = array(
						'date'    => $facture['date'],
						'montant' => $facture['total']
					);
		}

		
		$explorer = new stdClass();
		$explorer->actions = array("dragToZoom", "rightClickToReset");
		
		$listeview = new TListviewTBS('graphProject');
		print $listeview->renderArray($PDOdb, $TData
			,array(
				'type' => 'chart'
				,'chartType' => 'ColumnChart'
				,'liste'=>array(
					'titre'=> $langs->transnoentities('GraphFacturation')
				)
				,'hAxis'=>array('title'=> 'Date')
				,'vAxis'=>array('title'=> 'Montant')
				,'explorer'=>$explorer
			)
		);
		
	}
	
	function _print_filtres(){
		global $db, $langs;
		
		$id=(int) GETPOST('id');
		
		$Tform = new TFormCore($_SERVER["PHP_SELF"],'formFiltres', 'POST');
		_get_filtre($Tform);
	}
	
	
	function _get_filtre($form){
	    
	    print '<div class="tabBar">';
	    print '<table>';
		print '<tr>';
		print '<td>Date de début : </td>';
		print '<td>'.$form->calendrier('', 'date_deb', (GETPOST('date_deb'))? GETPOST('date_deb') : '').'</td>';
		print '</tr>';
		print '<tr>';
		print '<td>Date de fin : </td>';
		print '<td>'.$form->calendrier('', 'date_fin', (GETPOST('date_fin'))? GETPOST('date_fin') : '').'</td>';
		print '</tr>';
	
	    print '<tr><td colspan="2" align="center">'.$form->btsubmit('Valider', '').'</td></tr>';
	    print '</table>';
	    
	    print '</div>';
	}
	
	
	function _get_montant_factures($date_deb, $date_fin){
		global $db;
		
		$TData = array();
		
		$sql = 'SELECT COUNT(DISTINCT(f.rowid)) AS rowid, SUM(f.total) AS total, YEAR(f.datef) AS annee, MONTH(f.datef) AS mois, f.datef AS date FROM '.MAIN_DB_PREFIX.'facture f ';
		$sql .= 'WHERE f.datef BETWEEN "'.$date_deb.'" AND "'.$date_fin.'" ';
		$sql .= 'GROUP BY YEAR(f.datef), MONTH(f.datef)';
		$sql .= 'ORDER BY YEAR(f.datef) DESC, MONTH(f.datef) ASC';
		
		$resql = $db->query($sql);
		
		if ($resql){
			while ($line = $db->fetch_object($resql)){
				$TData[$line->mois] = array(
						'nbFacture' => intval($line->rowid),
						'total'     => intval($line->total),
						'annee'     => $line->annee,
						'mois'      => $line->mois,
						'date'      => date('Y-m', strtotime($line->date))
					);
				
			}
		}
		return $TData;
	}
	