<?php

require('config.php');
dol_include_once('/recouvrement/lib/recouvrement.lib.php');
dol_include_once('/recouvrement/class/etape.class.php');
dol_include_once('/recouvrement/class/procedure.class.php');
dol_include_once('/recouvrement/class/dossier.class.php');

 
if (!($user->rights->recouvrement->dossier->allow_free_events)) accessforbidden();



$PDOdb= new TPDOdb;




global $db;

$langs->load('recouvrement@recouvrement');



/*
 * Action
 */
$data['datasend'] = $_POST;
$data['result'] = 0; // by default if no action result is false
$data['errorMsg'] = ''; // default message for errors
$data['msg'] = $langs->trans('RecEtapeAdded'); // default message




$etape = new TRecEtape;




$parameters = array (
		'data' =>& $data,
		'etape' =>& $etape,
);
$reshook = $hookmanager->executeHooks('doActions', $parameters); // Note that $action and $object may have been modified by some hooks
if ($reshook < 0) setEventMessages($hookmanager->error, $hookmanager->errors, 'errors');

if (empty($reshook)) {
	// do action from GETPOST ...
	if(GETPOST('action'))
	{
		$action = GETPOST('action');
		
		
		if($action == 'add' || $action == 'edit')
		{
			$dossier_id= (int)GETPOST('dossier_id');
			$dossier = new TRecDossier();
			$dossier->load($PDOdb, $dossier_id);
			if($dossier->getId()>0)
			{
				
				$etape->name = GETPOST('name');
				
				if(empty($etape->name) || strlen($etape->name)>255)
				{
					$data['result'] = -1;
					$data['errorMsg'] = $langs->trans('NameInputInvalid');
				}
				
			}
			else
			{
				$data['result'] = -1; // by default if no action result is false
				$data['errorMsg'] = $langs->trans('FolderNotLoad').' '.$dossier_id; // default message for errors
				$data['msg'] = ''; // default message for errors
			}
			
			if($data['result']>=0)
			{
				
				$etape->fk_procedure = 0;
				$etape->rang= 0;
				$etape->delais= 0;
				$etapeRes = $etape->save($PDOdb);
				if($etapeRes)
				{
					$etapeHistory = new TRecEtapeHistory();
					$etapeHistory->fk_etape =  $etapeRes;
					$etapeHistory->fk_dossier=  $dossier_id;
					$etapeHistoryRes = $etapeHistory->save($PDOdb);
					if($etapeHistoryRes>0)
					{
						$data['result'] = 1;
					}
					else
					{
						$data['result'] = -1;
						$data['errorMsg'] = $langs->trans('RecEtapeSaveError').' HISTORYSAVE';
					}
					
				}
				else
				{
					$data['result'] = -1;
					$data['errorMsg'] = $langs->trans('SaveError');
				}
			}
			
		}
		

		
		
	}
}

echo json_encode($data);



