<?php

class FormRecouvrement {
	
	var $db;
	var $error;


	/**
	 *	Constructor
	 *
	 *  @param		DoliDB		$db      Database handler
	 */
	function __construct($db)
	{
		$this->db = $db;
		return 1;
	}
	
	function select_invoice($id_dossier, $socid=0)
	{
		global $conf;

        if ((float) DOL_VERSION < 10.0) $field_facture_ref = 'facnumber';
        else $field_facture_ref = 'ref';

		$sql = "SELECT f.rowid, f.".$field_facture_ref." as ref";

		$sql.= " FROM ".MAIN_DB_PREFIX."facture f LEFT JOIN ".MAIN_DB_PREFIX."rec_dossier_facture df ON (f.rowid=df.fk_facture AND df.fk_dossier=".$id_dossier.")";
		$sql.= ' LEFT JOIN '.MAIN_DB_PREFIX.'facture_extrafields fe ON (fe.fk_object = f.rowid)';
		$sql.= " WHERE df.rowid IS NULL"; // not linked
		if (!empty($socid)) {
			$sql.= " AND f.fk_soc=".$socid;
		}
		$sql.= ' AND f.entity='.getEntity('project')." AND f.paye!=1 AND fk_statut=1 ";
		$sql.= ' AND (fe.rec_exclude_to_process IS NULL OR fe.rec_exclude_to_process = 0)';
		$sql.= " ORDER BY ref DESC";

		dol_syslog(get_class($this).'::select_element sql='.$sql,LOG_DEBUG);

		$resql=$this->db->query($sql);
		if ($resql)
		{
			$num = $this->db->num_rows($resql);
			$i = 0;
			if ($num > 0)
			{
				$sellist = '<select class="flat" name="factureid">';
				while ($i < $num)
				{
					$obj = $this->db->fetch_object($resql);
					$sellist .='<option value="'.$obj->rowid.'">'.$obj->ref.'</option>';
					$i++;
				}
				$sellist .='</select>';
			}
			return $sellist ;

			$this->db->free($resql);
		}else {
			$this->error=$this->db->lasterror();
			dol_syslog(get_class($this) . "::select_element " . $this->error, LOG_ERR);
			return -1;
		}
	}
	
	
}
