<?php

class TRecEtape extends TObjetStd {
	function __construct() {
		global $langs;
		
		parent::set_table(MAIN_DB_PREFIX.'rec_etape');
		parent::add_champs('fk_procedure','type=entier;index;');
		parent::add_champs('rang,delais','type=entier;');
		parent::add_champs('ref,name,fk_action,titre_mail,bcc_mail,tpl_doc','type=chaine;');
		parent::add_champs('description,body_mail','type=text;');
		parent::add_champs('fk_service', array('type'=>'integer'));
		parent::start();
		parent::_init_vars();
		
		$this->setChild('TRecEtapeDocument', 'fk_etape');
		
		$this->TAction = array(
			"" =>" "
			,"mail"=>$langs->trans('recouvrement_action_send_mail')
			,"doc"=>$langs->trans('recouvrement_action_generate_doc')
			,"externaliser"=>$langs->trans('recouvrement_action_external')
			,"evenement"=>$langs->trans('recouvrement_action_reminder_agenda')
			,'penalty'=>$langs->trans('recouvrement_action_penalty')
		);
	}
	
	function addDocument($idDocument) {
		$iLien = $this->addChild($db, 'TRecEtapeDocument');
		$this->TRecEtapeDocument[$iLien]->fk_document = $idDocument;
	}
}

class TRecEtapeDocument extends TObjetStd {
	function __construct() {
		parent::set_table(MAIN_DB_PREFIX.'rec_etape_document');
		parent::add_champs('fk_etape,fk_document','type=entier;index;');
		parent::start();
		parent::_init_vars();
	}
}

class TRecEtapeHistory extends TObjetStd {
	function __construct() {
		parent::set_table(MAIN_DB_PREFIX.'rec_etape_history');
		parent::add_champs('fk_dossier,fk_etape,fk_commaction','type=entier;index;');
		parent::add_champs('date_etape','type=date;');
		parent::start();
		parent::_init_vars();
	}
}
