<?php

require('config.php');
//require('../../core/class/html.form.class.php');

set_time_limit(0);
ini_set('memory_limit', '1024M');

if (!($user->rights->recouvrement->dossier->write)) accessforbidden();

require('./class/dossier.class.php');
require('./class/etape.class.php');
require('./class/procedure.class.php');
dol_include_once('/compta/facture/class/facture.class.php');
dol_include_once('/core/class/html.form.class.php');
dol_include_once('/categories/class/categorie.class.php');

$ATMdb = new TPDOdb;

//$ATMdb->Execute("SET NAMES 'utf8'");

$tbs = new TTemplateTBS;
$dossier = new TRecDossier;

$mesg = '';
$error=false;

// Initialize technical object to manage hooks of page. Note that conf->hooks_modules contains array of hook context
$hookmanager->initHooks(array('recouvrementfacturelist'));

$allunpaid = GETPOST('allunpaid');
$allpaid = GETPOST('allpaid');
$TCategFilter = GETPOST('TCategFilter');

$action = __get('action','list');

$listViewUrl = $_SERVER['PHP_SELF'];

$parameters=array();
$reshook=$hookmanager->executeHooks('doActions',$parameters, $object, $action);    // Note that $action and $object may have been modified by some hooks
if ($reshook < 0) setEventMessages($hookmanager->error, $hookmanager->errors, 'errors');

if (empty($reshook))
{


	switch($action) {
		case 'list':
			_liste($ATMdb,$dossier);
			break;
		case 'attrib':
			$save_procedure = GETPOST('save_procedure');
			$save_procedure_without_step = GETPOST('save_procedure_without_step');
			
			if (!empty($save_procedure) || !empty($save_procedure_without_step))
			{
				_attribFacture($ATMdb,$_REQUEST);
			}
			
			_liste($ATMdb,$dossier);
			break;
			
		case 'print':
				$societe = new Societe($db);
				$societe->fetch((GETPOST('id_maison_mere') > 0) ? GETPOST('id_maison_mere') : GETPOST('id_tiers'));
			$TFacture = array_keys($_POST['TProcedure']);
				
				_genEtat(DOL_DATA_ROOT . '/recouvrement/unpaid/', $TFacture, $societe);
				
			break;
			
		case 'print_without_bills':
				$societe = new Societe($db);
				$societe->fetch((GETPOST('id_maison_mere') > 0) ? GETPOST('id_maison_mere') : GETPOST('id_tiers'));
			$TFacture = array_keys($_POST['TProcedure']);
				
				_genEtat(DOL_DATA_ROOT . '/recouvrement/unpaid/', $TFacture, $societe, true);
				
			break;
		
		case 'print_state_excel':
				$societe = new Societe($db);
				$societe->fetch((GETPOST('id_maison_mere') > 0) ? GETPOST('id_maison_mere') : GETPOST('id_tiers'));
			$TFacture = array_keys($_POST['TProcedure']);
				$conf->global->RECOUVREMENT_CONVERT_TO_PDF = false; // Même raison qu'au dessus
				_genEtat(DOL_DATA_ROOT . '/recouvrement/unpaid/', $TFacture, $societe, true, './tpl/etat_impayes'.$conf->global->RECOUVREMENT_FORMAT_EXCEL, true);
				
			break;
		
		case 'payment':
			$idSociete = (GETPOST('id_maison_mere') > 0) ? GETPOST('id_maison_mere') : GETPOST('id_tiers');
			
			header('Location: ' . dol_buildpath('/recouvrement/reglement.php', 2) . '?socid=' . $idSociete);
			exit;
			
			break;

		default :
			_liste($ATMdb,$dossier);
	}

}
llxFooter();

/*
 * View
 */
function _liste(&$ATMdb,$dossier) {
	global $langs, $db, $conf, $user, $allunpaid, $allpaid, $TCategFilter,$hookmanager, $listViewUrl;

	llxHeader('',$langs->trans('RecDossierListTitle'));

	$r = new TSSRenderControler($dossier);

	if ((float) DOL_VERSION < 10.0) $field_facture_ref = 'facnumber';
	else $field_facture_ref = 'ref';

	$sql = "SELECT f.rowid as idfac ,f.".$field_facture_ref." AS facnumber, f.fk_soc";
	
	if($conf->global->RECOUVREMENT_DONT_SHOW_OVERPAYMENT){
		$sql .= ", IF(SUM(pf.amount) IS NULL , 0, SUM(pf.amount)) as total_paiment ";
	}

	if(!empty($conf->global->RECOUVREMENT_PARENT_CASE)){
		$sql .= ",sm.rowid as parent,sm.nom as nomparent";
	}
	
	if (!empty($conf->global->RECOUVREMENT_SHOW_PROJECT)) $sql.= ', f.fk_projet, p.title AS projectName';
	$sql .= ", s.nom,s.zip, s.town, f.date_lim_reglement as DateLim, f.total, f.tva, total_ttc, '' as reste, '' as file";
    if(! empty($conf->global->RECOUVREMENT_SHOW_SELECT_FOLDER)) $sql .= ", '' as dossier";
    $sql .= ", f.rowid RecProc";
	
	// Add fields from hooks
	$parameters=array();
	$reshook=$hookmanager->executeHooks('printFieldListSelect',$parameters);    // Note that $action and $object may have been modified by hook
	$sql.=$hookmanager->resPrint;
	
	$sql.= " FROM ".MAIN_DB_PREFIX."facture as f LEFT OUTER JOIN ".MAIN_DB_PREFIX."rec_dossier_facture as df ON (df.fk_facture=f.rowid)
		 		LEFT JOIN ".MAIN_DB_PREFIX."societe as s ON (f.fk_soc = s.rowid)";
	$sql.= ' LEFT JOIN '.MAIN_DB_PREFIX.'facture_extrafields fe ON (fe.fk_object = f.rowid)';
	if($conf->global->RECOUVREMENT_PARENT_CASE){
		$sql .= " LEFT JOIN ".MAIN_DB_PREFIX."societe as sm ON (sm.rowid = s.parent)";
	}
	
	if(!_empty($TCategFilter)) {
		$field_soc = 'fk_societe';
		if((float)DOL_VERSION >= 3.8) $field_soc = 'fk_soc';
		$sql .= " LEFT JOIN ".MAIN_DB_PREFIX."categorie_societe as cs ON (cs.".$field_soc." = s.rowid) ";
	}
	
	if($conf->global->RECOUVREMENT_DONT_SHOW_OVERPAYMENT){
		$sql .= " LEFT JOIN ".MAIN_DB_PREFIX."paiement_facture as pf ON (pf.fk_facture = f.rowid) ";
	}
	
	if (!empty($conf->global->RECOUVREMENT_SHOW_PROJECT))
	{
		$sql.= ' LEFT JOIN '.MAIN_DB_PREFIX.'projet p ON (p.rowid = f.fk_projet)';
	}
	
	// Add fields from hooks
	$parameters=array();
	$reshook=$hookmanager->executeHooks('printFieldListJoin',$parameters);    // Note that $action and $object may have been modified by hook
	$sql.=$hookmanager->resPrint;
	
	$sql.= " WHERE f.entity IN (".getEntity('facture',1).") ";
	
	// Add where from hooks
	$parameters=array();
	$reshook=$hookmanager->executeHooks('printFieldListWhere',$parameters);    // Note that $action and $object may have been modified by hook
	$sql.=$hookmanager->resPrint;
	
	if($allunpaid != 1 && $allpaid != 1)$sql.=" AND f.date_lim_reglement < NOW() ";
 	
	if (empty($conf->global->RECOUVREMENT_ALLOW_PROV))
	{
		$sql.= " AND f.paye=".(int)$allpaid;
		$sql.= " AND f.fk_statut = ".(1 + (int)$allpaid); // 1 = validée, 2 = validée + payée	
	}
	else
	{
		$sql.= " AND f.paye=".(int)$allpaid;
		$sql.= " AND f.fk_statut IN (0, ".(1 + (int)$allpaid).")"; // 1 = validée, 2 = validée + payée
	}
 	
	if(!_empty($TCategFilter)) {
		$sql.= " AND cs.fk_categorie IN(".implode(',', $TCategFilter).") ";
	}
	
	$sql.= " AND f.total>0
			 AND type IN(0".(!empty($conf->global->RECOUVREMENT_ALLOWED_TYPES) ? ', '.implode(', ', unserialize($conf->global->RECOUVREMENT_ALLOWED_TYPES)) : '').")
			 AND df.rowid IS NULL ";
	
	if($conf->global->RECOUVREMENT_DONT_SHOW_OVERPAYMENT){
		$sql .= "  ";
	}

	$id_maison_mere = (int)GETPOST('id_maison_mere');
	$id_tiers = (int)GETPOST('id_tiers');

	if($id_maison_mere > 0) $sql.= " AND s.parent = ".$id_maison_mere;
	if($id_tiers > 0) $sql.= " AND s.rowid = ".$id_tiers;
	
	if(GETPOST('date_deb') || GETPOST('date_fin')) {

		$date_deb = (GETPOST('date_deb')>0) ? date('Y-m-d',Tools::get_time(GETPOST('date_deb'))) : date('Y-m-d',Tools::get_time('01/01/2000'));
		$date_fin = (GETPOST('date_fin')>0) ? date('Y-m-d',Tools::get_time(GETPOST('date_fin'))) : date('Y-m-d',Tools::get_time(date('d/m/Y')));

		$sql.= " AND f.date_lim_reglement BETWEEN '".$date_deb."' AND '".$date_fin."'";
	}
	
	$facnumber = GETPOST('facnumber', 'alpha');
	$projectName = GETPOST('projectName', 'alpha');
	$soc_name = GETPOST('soc_name', 'alpha');
	
	if (!empty($facnumber)) $sql .= natural_search('f.'.$field_facture_ref, $facnumber);
	if (!empty($projectName)) $sql .= natural_search('p.title', $projectName);
	if (!empty($soc_name)) $sql .= natural_search('s.nom', $soc_name);
	
	$sql.= ' AND (fe.rec_exclude_to_process IS NULL OR fe.rec_exclude_to_process = 0)';
	
	if($conf->global->RECOUVREMENT_DONT_SHOW_OVERPAYMENT){
		$sql .= " GROUP BY f.rowid 
				  HAVING f.total_ttc > total_paiment";
	}
	
	if($conf->global->RECOUVREMENT_DONT_SHOW_LINES_IF_NO_FILTER && ($allpaid || $allunpaid) && empty($id_maison_mere) && empty($id_tiers) && empty($TCategFilter)) $sql.= " LIMIT 0"; // Comme l'affichage est très long, on n'affiche les données qu'à partir du moment où il y a un filtre
	
	$THide = array('idfac','fk_soc','parent','total_paiment', 'fk_projet','tva','total');
	
	$TOrder = array('date_lim_reglement'=>'ASC');
	if(isset($_REQUEST['orderDown']))$TOrder = array($_REQUEST['orderDown']=>'DESC');
	if(isset($_REQUEST['orderUp']))$TOrder = array($_REQUEST['orderUp']=>'ASC');
	
	if($conf->global->RECOUVREMENT_PARENT_CASE)
		_afficheFormSelectDateAndMaisonMere();
	
	$formCore = new TFormCore($listViewUrl,'formAttribFacture','POST');
	$formCore->Set_typeaff('edit');
	
	//echo $sql;
			
	$sql2 = "SELECT rowid, name FROM ".MAIN_DB_PREFIX."rec_procedure";	
	
	$TProcedure = TRequeteCore::_get_id_by_sql($ATMdb, $sql2,'name','rowid');	

	if($allunpaid != 1 && $allpaid != 1){
		print 'Procédure à attribuer à l\'ensemble des factures : ';
		print '<select id="select_procedure" class="flat" name="select_procedure">';
		print '<option value="0">--- Sélectionnez une procédure ---</option>';
		
		foreach ($TProcedure as $rowid => $name) {
			print '<option value="'.($rowid).'">'.$name.'</option>';
		}
		
		print '</select>';
		
		echo $formCore->bt($langs->trans('Apply'), 'select_procedure_btn');
	}
	
	?>
	<script type="text/javascript">
		$(document).ready(function(){
			$('input[name=select_procedure_btn]').click(function(){
				
				$('#list_llx_rec_dossier select>option').each(function(){
					str = $(this).html();
					if($(this).val() == $('#select_procedure option:selected').val() && str.indexOf('dépassée de') > 0){
                        <?php if(! empty($conf->global->RECOUVREMENT_SHOW_SELECT_FOLDER)) { ?>
                            if($(this).closest('tr').find('select[name^=TDossier] option').length === 1)
                        <?php } ?>

                                $(this).attr('selected','selected');    // NOTE: Si la conf RECOUVREMENT_SHOW_SELECT_FOLDER est activée, cette ligne est imbriquée dans le 'if' juste en dessus
					}
				});
			});
			
			$('input[name=print_unpaid_state]').click(function() {
				$('form#formAttribFacture input[name=action]').val('print');
				$('form#formAttribFacture').submit();
			});
			
			$('input[name=print_unpaid_state_without_bills]').click(function() {
				$('form#formAttribFacture input[name=action]').val('print_without_bills');
				$('form#formAttribFacture').submit();
			});
			
			$('input[name=print_state_excel]').click(function() {
				$('form#formAttribFacture input[name=action]').val('print_state_excel');
				$('form#formAttribFacture').submit();
			});
			
			$('input[name=payment]').click(function() {
				$('form#formAttribFacture input[name=action]').val('payment');
				$('form#formAttribFacture').submit();
			});
			
			
	<?php

	if($allunpaid == 1 || $allpaid == 1){
				?>
				$('#list_llx_rec_dossier > thead > tr > th:last-child').hide();
				$('#list_llx_rec_dossier > tbody > tr > td:last-child').hide();
				<?php
	}
			?>
		});
	</script>
	<?php
		
	echo $formCore->hidden('action', 'attrib');
	echo $formCore->hidden('id_maison_mere', $id_maison_mere);
	echo $formCore->hidden('id_tiers', $id_tiers);
	
	if (!empty($conf->global->RECOUVREMENT_SHOW_PROJECT)) $TLink['projectName'] = '<a href="'.DOL_URL_ROOT.'/projet/fiche.php?id=@fk_projet@">'.img_picto('','object_projectpub.png', '', 0).' @val@</a>';
	
	if($allunpaid == 1) {
		$title = $langs->trans('RecAttributionFactureListAndUnpaid');
	} elseif($allpaid == 1) {
		$title = $langs->trans('RecAttributionFactureListAndPaid');
	} else {
		$title = $langs->trans('RecAttributionFactureList');
	}

	$TSearch = array(
                        	'facnumber'=>array('recherche'=>true, 'table'=>'f', 'field'=>$field_facture_ref)
                        	,'projectName'=>(!empty($conf->global->RECOUVREMENT_SHOW_PROJECT)) ? '<input type="text" name="projectName" value="'.$projectName.'" />' : ''
                        	,'nom'=>array('recherche'=>true, 'table'=>'s', 'field'=>'nom')
                        	,'zip'=>true
                        	,'town'=>true
                        );


	$listViewConfig = array(
			'limit'=>array(
					'page'=>(isset($_REQUEST['page']) ? $_REQUEST['page'] : 1)
					,'nbLine'=>(($id_maison_mere > 0 || !empty($TCategFilter)) ? 9999 : 50)
			)
			,'hide'=>$THide
			,'type'=>array(
					'DateLim'=>'date'
					,'total'=>'money'
					,'tva'=>'money'
					,'total_ttc'=>'money'
					,'reste'=>'money'
			)
			,'title'=>array(
					'facnumber' => 'Référence facture'
					,'projectName' => 'Projet'
					,'DateLim' => 'Date limite de réglement'
					,'town'=>'Ville'
					,'zip'=>'CP'
					,'nom' => 'Client'
					,'total' => 'Total HT'
					,'tva' => 'Total TVA'
					,'total_ttc' => 'Total TTC'
					,'reste'=>'Reste à payer'
					,'RecProc'=> 'Procédure à utiliser'
					,'nomparent'=>'Société Mère'
					,'file'=>'Fichier à utiliser'
			)
			,'search'=>$TSearch
			,'liste'=>array(
					'titre'=>$title
					,'image'=>img_picto('','recouvrement.png@recouvrement', '', 0)
					,'picto_precedent'=>img_picto('','back.png', '', 0)
					,'picto_suivant'=>img_picto('','next.png', '', 0)
					,'noheader'=> 0
					,'messageNothing'=>$langs->transnoentities('NoRecFactureToDisplay')
					,'order_down'=>img_picto('','1downarrow.png', '', 0)
					,'order_up'=>img_picto('','1uparrow.png', '', 0)
			)
			,'orderBy'=>$TOrder
			,'eval'=>array(
					'RecProc'=>'selectProcedure("@DateLim@",@idfac@)'
					,'nomparent'=>'_getNomUrl("@parent@","@val@")'
					,'nom'=>'_getNomUrl("@fk_soc@","@val@")'
					,'reste'=>'getSumPaiement(@idfac@)'
					,'file'=>'getComboFile(@idfac@)'
					,'facnumber'=>'_getNomUrlInvoice("@idfac@")'
			)
			,'math'=>array(
			/*			'total'=>'sum'
			 ,*/'total_ttc'=>'sum'
			 //			,'tva'=>'sum'
			)
			,'position'=>array(
					'text-align'=>array(
							'reste'=>'right'
					)
			)
	);
	if(! empty($conf->global->RECOUVREMENT_SHOW_SELECT_FOLDER)) {
        $listViewConfig['title']['dossier'] = 'Dossier à utiliser';
        $listViewConfig['eval']['dossier'] = 'getComboDossier("@fk_soc@", "@idfac@")';
    }
	// Change view from hooks
	$parameters=array(  'listViewConfig' => $listViewConfig);
	
	$reshook=$hookmanager->executeHooks('listViewConfig',$parameters,$r);    // Note that $action and $object may have been modified by hook
	if ($reshook < 0) setEventMessages($hookmanager->error, $hookmanager->errors, 'errors');
	if ($reshook>0)
	{
		$listViewConfig = $hookmanager->resArray;
	}
	
	$r->liste($ATMdb, $sql, $listViewConfig);
	
	?><div class="tabsAction"><?php 

		if($allunpaid == 1 || $allpaid == 1) {
			if($id_maison_mere>0 || $id_tiers >0 || !empty($TCategFilter)) {
				echo $formCore->bt('Etat excel', 'print_state_excel');
				if($allpaid != 1) {
					echo $formCore->bt('Etat des impayés', 'print_unpaid_state');
					echo $formCore->bt('Etat des impayés (sans factures jointes)', 'print_unpaid_state_without_bills');
					echo $formCore->bt('Emettre règlement', 'payment');
				}
			}
		}
		else{
			echo $formCore->btsubmit('Attribuer les factures et passer à la première étape', 'save_procedure'); 
			echo $formCore->btsubmit('Attribuer les factures sans effectuer d\'étape', 'save_procedure_without_step'); 
		}
		
		?></div><?php

	$formCore->end_form();
	
	echo '<br><br>';
}

function getComboFile($fk_facture) {
			
	return TRecDossierFacture::comboFile($fk_facture,'TProcedureFile['.$fk_facture.']');
	
}

function getComboDossier($fk_soc, $fk_facture) {
    $selected_value = GETPOST('TDossier['.$fk_soc.']['.$fk_facture.']');
    return TRecDossier::getCombo($fk_soc, $fk_facture, $selected_value);
}

function getSumPaiement($idfac){
	global $db;
	
	$facture = new Facture($db);
	$facture->fetch($idfac);
	
	$totalpaye = $facture->getSommePaiement();
	$totalcreditnotes = $facture->getSumCreditNotesUsed();
	$totaldeposits = $facture->getSumDepositsUsed();
	
	$resteapayer = price(price2num($facture->total_ttc - $totalpaye - $totalcreditnotes - $totaldeposits, 'MT'));
	
	return '<div align="right">'.$resteapayer.'</div>';
}

function _getNomUrl($fk_soc) {
global $db;	
	
	if(empty($fk_soc) ) return '';
	
	$soc=new Societe($db);
	$soc->fetch($fk_soc);
	
	return $soc->getNomUrl(1);
}

function _getNomUrlInvoice($invoice_id) {
	global $db;

	if(empty($invoice_id) ) return '';

	$obj=new Facture($db);
	$obj->fetch($invoice_id);

	return $obj->getNomUrl(1);
}

function _empty(&$TCategFilter) {
	
	$empty = true;
	
	if(empty($TCategFilter)) return 1;
	else {
		foreach ($TCategFilter as $id_categ) {
			if($id_categ > 0) {
				$empty = false;
				break;
			}
		}
	}
	
	return $empty;
	
}

function selectProcedure($date_lim_reglement,$idfac){
	global $listViewUrl;
	$ATMdb = new TPDOdb;
	
	$sql = "SELECT p.rowid, p.name, e.delais, e.name as nameEtape
			FROM ".MAIN_DB_PREFIX."rec_procedure as p
				LEFT JOIN ".MAIN_DB_PREFIX."rec_etape as e ON (e.fk_procedure = p.rowid)
			WHERE e.rang = 1
			ORDER BY p.rowid ASC";
	
	$form = new TFormCore($listViewUrl);
	
	//echo $date_lim_reglement.'<BR>';

	$ATMdb->Execute($sql);

	//echo $ATMdb->Get_field('delais'); exit;

	$Tprocedure = array(0=>'');
	while ($ATMdb->Get_line()) {

		$date = round((time() - strtotime($date_lim_reglement)) / 86400 );

		$delai = ($date - $ATMdb->Get_field('delais'));

		if($delai <= 0) $label = $ATMdb->Get_field('name')." (".abs($delai)." jour(s) avant 1ère étape '".$ATMdb->Get_field('nameEtape')."')";
		else $label = $ATMdb->Get_field('name')." (1ère étape '".$ATMdb->Get_field('nameEtape')."' dépassée de ".$delai." jour(s))";

		$Tprocedure[$ATMdb->Get_field('rowid')] = $label;
	}

	return $combo = $form->combo('', 'TProcedure['.$idfac.']', $Tprocedure, '');
}

function _afficheFormSelectDateAndMaisonMere() {
global $db, $langs, $allunpaid, $allpaid, $TCategFilter, $listViewUrl;
	
	$form = new TFormCore($listViewUrl,'formSelectDateAndMaisonMere','GET');
	
	$doliform = new Form($db);
	
	echo $form->hidden('action', 'list');
	echo $form->hidden('allunpaid', (int)$allunpaid);
	echo $form->hidden('allpaid', (int)$allpaid);
	
	echo $form->combo('Maison mère : ', 'id_maison_mere', _getListeTiers(true), (int)GETPOST('id_maison_mere'));
	echo " OU ".$form->combo('Lot/Copro : ', 'id_tiers', _getListeTiers(), (int)GETPOST('id_tiers'));
	echo '<br><br>Catégorie(s) maison mère : ';
	
	if((float)DOL_VERSION >= 3.8) {
		$cate_arbo = $doliform->select_all_categories(Categorie::TYPE_CUSTOMER, null, null, null, null, 1);
		echo $doliform->multiselectarray('TCategFilter', $cate_arbo, $TCategFilter, '', 0, '', 0, '40%');
	} else {
		echo $doliform->select_all_categories(2, !empty($TCategFilter[0]) ? $TCategFilter[0] : '', 'TCategFilter[]', null, null, 1);
		echo $doliform->select_all_categories(2, !empty($TCategFilter[1]) ? $TCategFilter[1] : '', 'TCategFilter[]', null, null, 1);
		echo $doliform->select_all_categories(2, !empty($TCategFilter[2]) ? $TCategFilter[2] : '', 'TCategFilter[]', null, null, 1);
	}
	
	echo '<br><br>'.$langs->trans('DateStart').' : '. $form->calendrier('', "date_deb", GETPOST('date_deb'));
	echo ' - '.$langs->trans('DateEnd').' : '.$form->calendrier('', "date_fin", GETPOST('date_fin'));
	
	echo $form->btsubmit('Filtrer', 'filtre_maison_mere_et_date');
	
	$form->end();
	
	echo "<br />";
		
}

function _getListeTiers($maisonMere=false) {
	
	global $db;
	
	$TMaisonMere = array(0 => "(Sélectionnez une maison mère)");
	
	$sql = 'SELECT s1.rowid, s1.nom
			FROM '.MAIN_DB_PREFIX.'societe AS s1';
			
	if($maisonMere) $sql .= ' INNER JOIN ' . MAIN_DB_PREFIX . 'societe AS s2 ON s2.parent = s1.rowid';
	
	$sql .= ' GROUP BY s1.rowid ORDER BY nom';

	$resql = $db->query($sql);
	
	while($res = $db->fetch_object($resql))
		$TMaisonMere[$res->rowid] = $res->nom;
			
	return $TMaisonMere;
	
}
