<?php

require('../config.php');
dol_include_once('/recouvrement/lib/recouvrement.lib.php');

if (!($user->rights->recouvrement->dossier->admin)) accessforbidden();

require('../class/etape.class.php');
require('../class/procedure.class.php');

llxHeader('',$langs->trans('RecouvrementAdmin'));

$head = recouvrement_admin_prepare_head();

dol_fiche_head($head, 'procedure', $langs->trans("Recouvrement"), 0, 'recouvrementico@recouvrement');

$ATMdb = new TPDOdb;
$ATMdb = new TPDOdb;
//$ATMdb->Execute("SET NAMES 'utf8'");

$tbs = new TTemplateTBS;
$procedure = new TRecProcedure();
$procedure->loadChild($ATMdb);

$mesg = '';
$error=false;

$action = GETPOST('action');
if(!empty($_REQUEST['cancel'])) $action = 'cancel';

if(!empty($action)) {
	switch($action) {
		case 'list':
			_liste($ATMdb, $procedure);
			break;
		case 'cancel':
			$procedure->load($ATMdb, $_REQUEST['id']);
			_fiche($ATMdb, $procedure, 'view');
			break;
		case 'add':
		case 'new':
			
			$procedure->set_values($_REQUEST);
			_fiche($ATMdb, $procedure,'new');
			
			break;
		case 'edit'	:
		
			$procedure->load($ATMdb, $_REQUEST['id']);
			
			_fiche($ATMdb, $procedure,'edit');
			break;
			
		case 'save':
			$procedure->load($ATMdb, $_REQUEST['id']);
			
			// Vérification qu'il n'existe pas d'autre procédure par défaut
			$is_default = GETPOST('is_default');
			
			if ($is_default) {
				$obj = _exist_default_procedure($ATMdb, $procedure->getId());
				
				if (!empty($obj)) {
					$default_proc = new TRecProcedure;
					$default_proc->load($ATMdb, $obj->rowid);
					
					$default_proc->is_default = 0;
					$default_proc->save($ATMdb);
				}
			}
			
			$procedure->set_values($_REQUEST);
			
			$procedure->save($ATMdb);
			
			_fiche($ATMdb, $procedure, 'view');
			
			break;
		
			
		case 'delete':
			$procedure->load($ATMdb, $_REQUEST['id']);
			$procedure->delete($ATMdb);
			
			?>
			<script language="javascript">
				document.location.href="?delete_ok=1";
			</script>
			<?php
			
			break;
	}
}
elseif(isset($_REQUEST['id'])) {
	$procedure->load($ATMdb, $_REQUEST['id']);
	_fiche($ATMdb, $procedure, 'view');
}
else {
	 _liste($ATMdb, $procedure);
}

llxFooter();

/*
 * View
 */
function _liste(&$ATMdb, &$procedure) {
	global $langs, $db, $conf, $user;
	
	$r = new TSSRenderControler($procedure);
	
	$sql = " SELECT p.rowid, p.name, (SELECT COUNT(*) FROM ".MAIN_DB_PREFIX."rec_etape WHERE fk_procedure = p.rowid) as nbEtape, p.description, p.is_default";
	$sql.= " FROM ".MAIN_DB_PREFIX."rec_procedure as p";
	$sql.= " WHERE p.entity IN (".getEntity('rec_procedure',1).")";
	
	//echo $sql;
	
	$THide = array('rowid');
	
	$TOrder = array('rowid'=>'ASC');
	if(isset($_REQUEST['orderDown']))$TOrder = array($_REQUEST['orderDown']=>'DESC');
	if(isset($_REQUEST['orderUp']))$TOrder = array($_REQUEST['orderUp']=>'ASC');
	
	/*echo '<pre>';
	print_r($procedure);
	echo '</pre>';exit;*/
	
	$r->liste($ATMdb, $sql, array(
		'limit'=>array(
			'page'=>(isset($_REQUEST['page']) ? $_REQUEST['page'] : 0)
			,'nbLine'=>'10'
		)
		,'link'=>array(
			'name'=>img_picto('', 'object_list').' <a href="?id=@rowid@">@val@</a>',
		)
		,'title'=>array(
			'name'=>$langs->trans('RecProcedureTitleName')
			,'description'=>$langs->trans('RecProcedureTitleDescription')
			,'nbEtape'=>$langs->trans('RecProcedureTitleNbEtape')
			,'is_default'=>$langs->trans('RecProcedureTitleIsDefault')
		)
		,'hide'=>$THide
		,'type'=>array()
		,'liste'=>array(
			'titre'=>$langs->trans('RecProcedureList')
			,'picto_precedent'=>img_picto('','back.png', '', 0)
			,'picto_suivant'=>img_picto('','next.png', '', 0)
			,'noheader'=> 0
			,'messageNothing'=>$langs->transnoentities('NoRecProcedureToDisplay')
			,'order_down'=>img_picto('','1downarrow.png', '', 0)
			,'order_up'=>img_picto('','1uparrow.png', '', 0)
		)
		,'orderBy'=>$TOrder
		,'eval' => array(
			'is_default' => '(@val@ == 1 ? "Oui" : "Non")'
		)
	));
	
	?><br><div style="text-align: right;"><a href="?action=new" class="butAction"><?php echo $langs->trans("NewRecProcedure"); ?></a></div><br><?php
}

function _fiche(&$ATMdb, &$procedure, $mode) {
	global $db, $langs, $user, $conf;
	
	/*
	 * FICHE PROCEDURE
	 */
	
	$formDoli = new Form($db);
	$form=new TFormCore($_SERVER['PHP_SELF'],'formscore','POST');
	$form->Set_typeaff($mode);
	
	echo $form->hidden('id', $procedure->getId());
	echo $form->hidden('action', 'save');
	echo $form->hidden('entity', $conf->entity);

	$TBS=new TTemplateTBS();
	$buttons = '';
	if($mode == 'view') {
		$buttons .= '<br><a href="'.$_SERVER['SELF'].'?action=list" class="butAction">'.$langs->trans('Retour').'</a>';
		$buttons .= '<a href="'.$_SERVER['SELF'].'?action=edit&id='.$procedure->getId().'" class="butAction">'.$langs->trans('Modify').'</a>';
		$buttons .= '<a href="'.$_SERVER['SELF'].'?action=delete&id='.$procedure->getId().'" class="butActionDelete">'.$langs->trans('Delete').'</a>';
	} else {
		$buttons .= $form->btsubmit($langs->trans('Save'), 'save');
		$buttons .= $form->btsubmit($langs->trans('Cancel'), 'cancel');
	}
	
	if($mode == 'edit')
		$title = $langs->trans("EditRecProcedure");
	elseif($mode == 'new')
		$title = $langs->trans("NewRecProcedure");
	else
		$title = $langs->trans("FicheRecProcedure");
	
	if ($mode == 'edit') {
		$is_default = $formDoli->selectyesno('is_default', $procedure->is_default, 1);
	} else {
		$is_default = ($procedure->is_default ? 'Oui' : 'Non');
	}
	
	if ($mode == 'edit') {
		$allow_free_events= $formDoli->selectyesno('allow_free_events', $procedure->allow_free_events, 1);
	} else {
		$allow_free_events= ($procedure->allow_free_events? 'Oui' : 'Non');
	}
	
	print $TBS->render('../tpl/procedure.tpl.php'
		,array(
			
		)
		,array(
			'procedure'=>array(
				'title'=>$title
				,'id'=>$procedure->getId()
				,'name'=>$form->texte('', 'name', $procedure->name, 20)
				,'title_name'=>$langs->trans('RecProcedureTitleName')
				,'description'=>$form->zonetexte('', 'description', $procedure->description, 50)
				,'title_description'=>$langs->trans('RecProcedureTitleDescription')
				,'title_is_default'=>$langs->trans('RecProcedureTitleIsDefault')
				,'is_default' => $is_default
				,'title_allow_free_events'=>$langs->trans('RecProcedureTitleAllowFreeEvents')
				,'allow_free_events' => $allow_free_events
				,'buttons'=>$buttons
			)
			,'view'=>array(
				'mode'=>$mode
			)
		)
	);
	
	echo $form->end_form();
	
	if($mode == 'view') {
		
		echo '<br><br>';
		_listeEtape($procedure,$ATMdb);
		
		echo '<br><br>';
		_listeDossier($procedure,$ATMdb);
	}

	global $mesg, $error;
	dol_htmloutput_mesg($mesg, '', ($error ? 'error' : 'ok'));
}

function _listeEtape(&$procedure,&$ATMdb){
	global $langs, $db, $conf, $user;
	
	$r = new TSSRenderControler($procedure);
	
	$sql = " SELECT e.rowid, e.rang, e.name, e.fk_action, e.delais";
	$sql.= " FROM ".MAIN_DB_PREFIX."rec_etape as e";
	$sql.= " WHERE e.fk_procedure = ".$procedure->rowid;
	
	$THide = array('rowid');
	
	$etape_static = new TRecEtape;
	$TEtape = $etape_static->TAction;
	
	$TOrder = array('rang'=>'ASC');
	if(isset($_REQUEST['orderDown']))$TOrder = array($_REQUEST['orderDown']=>'DESC');
	if(isset($_REQUEST['orderUp']))$TOrder = array($_REQUEST['orderUp']=>'ASC');
	
	$r->liste($ATMdb, $sql, array(
		'limit'=>array(
			'page'=>(isset($_REQUEST['page']) ? $_REQUEST['page'] : 0)
			,'nbLine'=>'10'
		)
		,'link'=>array(
			'name'=>img_picto('', 'object_list').' <a href="etape.php?id=@rowid@&fk_procedure='.$procedure->getId().'">@val@</a>',
			'delais'=>'@val@ jours'
		)
		,'translate'=>array(
			'fk_action'=>$TEtape
		)
		,'title'=>array(
			'name'=>$langs->trans('RecEtapeTitleName')
			,'order'=>$langs->trans('RecEtapeTitleOrder')
			,'delais'=>$langs->trans('RecEtapeTitleDelais')
			,'fk_action'=>$langs->trans('RecEtapeTitleAction')
		)
		,'hide'=>$THide
		,'type'=>array()
		,'liste'=>array(
			'titre'=>$langs->trans('RecEtapeList')
			,'picto_precedent'=>img_picto('','back.png', '', 0)
			,'picto_suivant'=>img_picto('','next.png', '', 0)
			,'noheader'=> 0
			,'messageNothing'=>$langs->transnoentities('NoRecEtapeToDisplay')
			,'order_down'=>img_picto('','1downarrow.png', '', 0)
			,'order_up'=>img_picto('','1uparrow.png','', 0)
		)
		,'orderBy'=>$TOrder
	));
	
	?><div class="tabsAction"><a href="etape.php?action=new&fk_procedure=<?php echo $procedure->getId(); ?>" class="butAction"><?php echo $langs->trans("NewRecEtape"); ?></a></div><?php
}

function _listeDossier(&$procedure,&$ATMdb){
	global $langs, $db, $conf, $user;
	
	$r = new TSSRenderControler($procedure);
	
	$sql = " SELECT d.rowid as rowid, d.ref, s.rowid as idsoc, s.nom, d.fk_etape, e.rowid as idetape, e.name";
	$sql.= " FROM ".MAIN_DB_PREFIX."rec_dossier as d 
				LEFT JOIN ".MAIN_DB_PREFIX."societe as s ON (s.rowid = d.fk_soc)
				LEFT JOIN ".MAIN_DB_PREFIX."rec_etape as e ON (e.rowid = d.fk_etape)";
	$sql.= " WHERE d.fk_procedure = ".$procedure->rowid;
	
	$THide = array('rowid','idsoc','idetape');
	
	$TOrder = array('ref'=>'DESC');
	if(isset($_REQUEST['orderDown']))$TOrder = array($_REQUEST['orderDown']=>'DESC');
	if(isset($_REQUEST['orderUp']))$TOrder = array($_REQUEST['orderUp']=>'ASC');
	
	$r->liste($ATMdb, $sql, array(
		'limit'=>array(
			'page'=>(isset($_REQUEST['page']) ? $_REQUEST['page'] : 0)
			,'nbLine'=>'10'
		)
		,'link'=>array(
			'ref'=>img_picto('', 'object_dir').' <a href="../dossier.php?id=@rowid@">@val@</a>',
			
		)
		,'title'=>array(
			'ref'=>$langs->trans('RecDossierTitleRef'),
			'nom'=>$langs->trans('RecDossierTitleSociete'),
			'name'=>$langs->trans('RecEtapeTitleName'),
			'fk_etape'=>$langs->trans('RecDossierTitleEtape')
		)
		,'hide'=>$THide
		,'type'=>array()
		,'liste'=>array(
			'titre'=>$langs->trans('RecDossierListTitle')
			,'picto_precedent'=>img_picto('','back.png', '', 0)
			,'picto_suivant'=>img_picto('','next.png', '', 0)
			,'noheader'=> 0
			,'messageNothing'=>$langs->transnoentities('NoRecDossierToDisplay')
			,'order_down'=>img_picto('','1downarrow.png', '', 0)
			,'order_up'=>img_picto('','1uparrow.png','', 0)
		)
		,'eval'=>array(
			'nom'=>'_getSocUrl(@idsoc@)'
		)
		,'orderBy'=>$TOrder
	));
}

function _getSocUrl($fk_soc) {
	global $db;
	
	$soc = new Societe($db);
	$soc->fetch($fk_soc);
	
	return $soc->getNomUrl(1);
	
}

function _exist_default_procedure(&$ATMdb, $proc_id) {
	$sql = '
		SELECT rowid
		FROM ' . MAIN_DB_PREFIX . 'rec_procedure
		WHERE is_default = 1
		AND rowid <> ' . $proc_id . '
	';
	
	$dataset = $ATMdb->Execute($sql);
	$obj = $ATMdb->Get_line();
	
	if ($obj !== false) {
		return $obj;
	} else {
		return false;
	}
}
