<?php
class ActionsPrelevementpf{
	/** @var DoliDB $db */
	protected $db;
	public $dao;
	public $error;
	public $errors = array();
	public $resPrint = '';
	public $results = array();

	/**
	 * Constructor
	 *
	 * @param DoliDB $db
	 */
	public function __construct($db)
	{
		$this->db = $db;
		$this->error = 0;
		$this->errors = array();
	}

	public function doActions($parameters, &$object, &$action, $hookmanager){
		global $langs, $conf, $user, $mc;

		return 0;
	}

    /**
	 * addMoreActionsButtons
	 *
	 * @param array	 	$parameters	Parameters
	 * @param Object	$object		Object
	 * @param string	$action		action
	 * @return int					0
	 */
	public function addMoreActionsButtons($parameters, &$object, &$action)
	{
		global $db, $conf, $user, $langs, $form;
		$totalpaye = 0;
		$nbCreditNote = 0;

		if (is_object($object) && $object->element == 'facture') {
			// On verifie si la facture a des paiements
			$sql = 'SELECT pf.amount';
			$sql .= ' FROM '.MAIN_DB_PREFIX.'paiement_facture as pf';
			$sql .= ' WHERE pf.fk_facture = '.$object->id;

			$result = $this->db->query($sql);
			if ($result) {
				$i = 0;
				$num = $this->db->num_rows($result);

				while ($i < $num) {
					$objp = $this->db->fetch_object($result);
					$totalpaye += $objp->amount;
					$i++;
				}
			} else {
				dol_print_error($this->db, '');
            }
            
            $sql = "SELECT re.rowid, re.amount_ht, re.amount_tva, re.amount_ttc,";
            $sql .= " re.description, re.fk_facture_source";
            $sql .= " FROM ".MAIN_DB_PREFIX."societe_remise_except as re";
            $sql .= " WHERE fk_facture = ".$object->id;
            $resql = $db->query($sql);
            $result = $this->db->query($sql);
			if ($result) {
				$nbCreditNote = $this->db->num_rows($result);
			} else {
				dol_print_error($this->db, '');
            }

            $objectidnext = $object->getIdReplacingInvoice();
			$usercancreatewithdrarequest = $user->rights->prelevementpf->bons->creer;
			
			$resteapayer = $object->total_ttc - $totalpaye;
			// Request a direct debit order
			if ($object->statut > Facture::STATUS_DRAFT && $object->paye == 0 && $nbCreditNote == 0)
			{
				if ($resteapayer > 0)
				{
			        if ($usercancreatewithdrarequest)
					{
						if (!$objectidnext && $object->close_code != 'replaced') 				// Not replaced by another invoice
						{
							print '<a class="butAction" href="'.dol_buildpath('/prelevementpf/prelevement.php',1).'?facid='.$object->id.'" title="'.dol_escape_htmltag($langs->trans("MakeWithdrawRequest")).'">'.$langs->trans("MakeWithdrawRequest").'</a>';
                        } else {
							print '<span class="butActionRefused classfortooltip" title="'.$langs->trans("DisabledBecauseReplacedInvoice").'">'.$langs->trans('MakeWithdrawRequest').'</span>';
						}
                    }
				} 
			}
		} 
		return 0;
	}

    /**
	 * addMoreMassActions
	 *
	 * Ajoute aux actions en masses 
	 * sur la liste des factures, ajout de la demande de paiement
	 * @param array	 	$parameters	Parameters
	 * @param Object	$object		Object
	 * @param string	$action		action
	 * @return int					0
	 */
	public function addMoreMassActions($parameters, &$object, &$action)
	{
		global $langs;

		$langs->load("withdrawals");
		switch( $parameters['currentcontext'] ){
		case 'invoicelist' : 
			$this->resprints .= '<option value="withdrawpfrequest"  data-html="'.dol_escape_htmltag($langs->trans("MakeWithdrawRequest")).'">'.$langs->trans("MakeWithdrawRequest").'</option>';
		}
	}
	
	
	/**
	* doMassActions
	*
	* Traite les actions en masses
	* demande de paiement sur la liste des factures
	* @param array	 	$parameters	Parameters
	* @param Object	$object		Object
	* @param string	$action		action
	* @return int					0
	*/
   public function doMassActions($parameters, &$object, &$action)
   {
	    global $user, $langs, $db;

		$langs->load("withdrawals");
	    if($parameters['currentcontext']=='invoicelist'){
			if($parameters['massaction']=='withdrawpfrequest'){
				require_once DOL_DOCUMENT_ROOT.'/custom/prelevementpf/class/facturepf.class.php';
				
				if (!$user->rights->prelevementpf->bons->creer) {
					$error++;
					setEventMessages($langs->trans("NotEnoughPermissions"), null, 'errors');
				} else {
					//Checking error
					$error = 0;
					
					$arrayofselected = is_array($parameters['toselect']) ? $parameters['toselect'] : array();
					$listofbills = array();
					foreach ($arrayofselected as $toselectid)
					{
						$objecttmp = new FacturePF($db);
						$result = $objecttmp->fetch($toselectid);
						if ($result > 0) {
							$totalpaye = $objecttmp->getSommePaiement();
							$totalcreditnotes = $objecttmp->getSumCreditNotesUsed();
							$totaldeposits = $objecttmp->getSumDepositsUsed();
							$objecttmp->resteapayer = price2num($objecttmp->total_ttc - $totalpaye - $totalcreditnotes - $totaldeposits, 'MT');
							if ($objecttmp->paye || $objecttmp->resteapayer == 0) {
								$error++;
								setEventMessages($objecttmp->ref.' '.$langs->trans("AlreadyPaid"), $objecttmp->errors, 'errors');
							} elseif ($objecttmp->resteapayer < 0) {
								$error++;
								setEventMessages($objecttmp->ref.' '.$langs->trans("AmountMustBePositive"), $objecttmp->errors, 'errors');
							}
							if (!($objecttmp->statut > FacturePF::STATUS_DRAFT)) {
								$error++;
								setEventMessages($objecttmp->ref.' '.$langs->trans("Draft"), $objecttmp->errors, 'errors');
							}

							$rsql = "SELECT pfd.rowid, pfd.traite, pfd.date_demande as date_demande";
							$rsql .= " , pfd.date_traite as date_traite";
							$rsql .= " , pfd.amount";
							$rsql .= " , u.rowid as user_id, u.lastname, u.firstname, u.login";
							$rsql .= " FROM ".MAIN_DB_PREFIX."prelevementpf_facture_demande as pfd";
							$rsql .= " , ".MAIN_DB_PREFIX."user as u";
							$rsql .= " WHERE fk_facture = ".$objecttmp->id;
							$rsql .= " AND pfd.fk_user_demande = u.rowid";
							$rsql .= " AND pfd.traite = 0";
							$rsql .= " ORDER BY pfd.date_demande DESC";

							$result_sql = $db->query($rsql);
							if ($result_sql)
							{
								$numprlv = $db->num_rows($result_sql);
							}

							if ($numprlv > 0) {
								$error++;
								setEventMessages($objecttmp->ref.' '.$langs->trans("RequestAlreadyDone"), $objecttmp->errors, 'warnings');
							} elseif (!empty($objecttmp->mode_reglement_code) && $objecttmp->mode_reglement_code != 'PRE') {
								$error++;
								setEventMessages($objecttmp->ref.' '.$langs->trans("BadPaymentMethod"), $objecttmp->errors, 'errors');
							} else {
								$listofbills[] = $objecttmp; // $listofbills will only contains invoices with good payment method and no request already done
							}
						}
					}

					//Massive withdraw request for request with no errors
					if (!empty($listofbills))
					{
						$nbwithdrawrequestok = 0;
						
						foreach ($listofbills as $aBill)
						{
							$db->begin();
							$result = $aBill->demande_prelevement($user, $aBill->resteapayer, 'direct-debit', 'facture');
							if ($result > 0)
							{
								$db->commit();
								$nbwithdrawrequestok++;
							} else {
								$db->rollback();
								setEventMessages($aBill->error, $aBill->errors, 'errors');
							}
						}
						if ($nbwithdrawrequestok > 0)
						{
							setEventMessages($langs->trans("WithdrawRequestsDone", $nbwithdrawrequestok), null, 'mesgs');
						}
					}
				}
			}
	    }

   }
}