<?php
/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) 2012-2013 jacquel jerome <icfr.eirl@free.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *              \file      
 * 		\ingroup   
 * 		\brief      
 * 		\version    
 * 		\author		jacquel jerome icfr eirl
 * 		
 */
$res = 0;
if (!$res && file_exists("../main.inc.php")) {
    $res = @include("../main.inc.php");
}
if (!$res && file_exists("../../main.inc.php")) {
    $res = @include("../../main.inc.php");
}
if (!$res && file_exists("../../../main.inc.php")) {
    $res = @include("../../../main.inc.php");
}
require_once(DOL_DOCUMENT_ROOT . "/core/lib/company.lib.php");
//require_once(DOL_DOCUMENT_ROOT . "/comm/prospect/class/prospect.class.php");
require_once(DOL_DOCUMENT_ROOT . "/core/class/html.formcompany.class.php");
require_once(DOL_DOCUMENT_ROOT . "/contact/class/contact.class.php");
require_once(DOL_DOCUMENT_ROOT . "/comm/action/class/actioncomm.class.php");
if ($conf->adherent->enabled)
    require_once(DOL_DOCUMENT_ROOT . "/adherents/class/adherent.class.php");
if ($conf->propal->enabled)
    require_once(DOL_DOCUMENT_ROOT . "/comm/propal/class/propal.class.php");
$res = 0;
if (!$res && file_exists(DOL_DOCUMENT_ROOT . "/echeancier/class/echeancier.class.php"))
    $res = include(DOL_DOCUMENT_ROOT . "/echeancier/class/echeancier.class.php");
if (!$res && file_exists("./class/echeancier.class.php"))
    $res = include("./class/echeancier.class.php");
if (!$res)
    die("Include of echeancier class fails");


if (isset($_GET["id"]))
    $socid = isset($_GET["id"]) ? $_GET["id"] : '';
if (isset($_GET["socid"]))
    $socid = isset($_GET["socid"]) ? $_GET["socid"] : '';
if ($user->societe_id)
    $socid = $user->societe_id;
$form = new Form($db);
$langs->load("echeancier@echeancier");
$id = $socid;
$formcompany = new FormCompany($db);
$societe = new Societe($db);
$result = $societe->fetch($socid);

$css = array('/echeancier/css/styles.css');
llxHeader('', 'Echeancier', '', '', '', '', $js, $css);
print_fiche_titre($langs->trans("échéancier du client"));
$head = societe_prepare_head($societe);
dol_fiche_head($head, 'tabEcheancier', $langs->trans("ThirdParty"), 0, 'company');

print '<table class="border" width="100%">';

print '<tr><td width="25%">' . $langs->trans("ThirdPartyName") . '</td><td colspan="3">';
print $form->showrefnav($societe, 'socid', '', ($user->societe_id ? 0 : 1), 'rowid', 'nom', '', '&element=custumer');
print '</td></tr>';

if (!empty($conf->global->SOCIETE_USEPREFIX)) {
    print '<tr><td>' . $langs->trans('Prefix') . '</td><td colspan="3">' . $societe->prefix_comm . '</td></tr>';
}

if ($societe->client) {
    print '<tr><td>';
    print $langs->trans('CustomerCode') . '</td><td colspan="3">';
    print $societe->code_client;
    if ($societe->check_codeclient() <> 0)
        print ' <font class="error">(' . $langs->trans("WrongCustomerCode") . ')</font>';
    print '</td></tr>';
}

if ($societe->fournisseur) {
    print '<tr><td>';
    print $langs->trans('SupplierCode') . '</td><td colspan="3">';
    print $societe->code_fournisseur;
    if ($societe->check_codefournisseur() <> 0)
        print ' <font class="error">(' . $langs->trans("WrongSupplierCode") . ')</font>';
    print '</td></tr>';
}

if ($conf->global->MAIN_MODULE_BARCODE) {
    print '<tr><td>' . $langs->trans('Gencod') . '</td><td colspan="3">' . $societe->gencod . '</td></tr>';
}

print "<tr><td valign=\"top\">" . $langs->trans('Address') . "</td><td colspan=\"3\">";
dol_print_address($societe->address, 'gmap', 'thirdparty', $societe->id);
print "</td></tr>";

// Zip / Town
print '<tr><td width="25%">' . $langs->trans('Zip') . '</td><td width="25%">' . $societe->cp . "</td>";
print '<td width="25%">' . $langs->trans('Town') . '</td><td width="25%">' . $societe->ville . "</td></tr>";

// Country
if ($societe->pays) {
    print '<tr><td>' . $langs->trans('Country') . '</td><td colspan="3">';
    $img = picto_from_langcode($societe->pays_code);
    print ($img ? $img . ' ' : '');
    print $societe->pays;
    print '</td></tr>';
}

print '<tr><td>' . $langs->trans('Phone') . '</td><td>' . dol_print_phone($societe->tel, $soc->pays_code, 0, $societe->id, 'AC_TEL') . '</td>';
print '<td>' . $langs->trans('Fax') . '</td><td>' . dol_print_phone($societe->fax, $soc->pays_code, 0, $soc->id, 'AC_FAX') . '</td></tr>';

// EMail
print '<tr><td>' . $langs->trans('EMail') . '</td><td>';
print dol_print_email($societe->email, 0, $soc->id, 'AC_EMAIL');
print '</td>';

// Web
print '<td>' . $langs->trans('Web') . '</td><td>';
print dol_print_url($societe->url);
print '</td></tr>';

print '</table></div>';


$echeancier = new echeancier($db);
$echeancier_list = $echeancier->GetEcheancesFromClient($socid);



if (is_array($echeancier_list)){
print '<table id="ticket" class="noborder" width="100%" >';


print '<thead><tr class="liste_titre"><th>' . $langs->trans('facture') . '</th><th>' . $langs->trans('montant') . '</th><th>' . $langs->trans('écheance') . '</th><th>' . $langs->trans('LastEcheance') . '</th><th></th></tr></thead>'; 
print '</table>';
print '<div class="corp">';
$fact = FALSE;
foreach ($echeancier_list as $id_echeancier) {
    $echeancier->fetch($id_echeancier);
    
     
     if ($echeancier->type == 2){
        
     print '<form action="modif_echeancier_facture.php" method="post">';
     
     
     }  else {
         
      print '<form action="modif_echeancier_propal.php" method="post">';
         
     }
     
     $bc = array(0=>'pair',1=>'impair');
     print '<p ' . $bc[$var] . '>';
     print '<input type="hidden" name="action" value="modifie">';
        print '<input type="hidden" name="token" value="' . $_SESSION['newtoken'] . '">';
        print '<input type="hidden" name="ide" value="' . $echeancier->id . '">';
        print '<input type="hidden" name="montant" value="' . $echeancier->montant . '">';
        print '<input type="hidden" name="id_client" value="'. GETPOST('id_client') .'">';
         print '<input type="hidden" name="socid" value="'. $socid .'">';
         print '<input type="hidden" name="redirect" value="'. $_SERVER['PHP_SELF'] .'">';
         
    $var = !$var;
    
    if ($echeancier->type == 2 && $user->rights->echeancier->facture){
        $fact = TRUE;
        if (DOL_VERSION < 6.0) {
            print '<span class="facture  ' . $bc[$var] . '"><a href="' . DOL_MAIN_URL_ROOT . '/compta/facture.php?facid=' . $echeancier->id_element . '">' . $echeancier->ref_element . '</a></span>';
        } else {
            print '<span class="facture  ' . $bc[$var] . '"><a href="' . DOL_MAIN_URL_ROOT . '/compta/facture/card.php?facid=' . $echeancier->id_element . '">' . $echeancier->ref_element . '</a></span>';
        }
        $enable = '';
        print '<span class="montant ' . $bc[$var] . '" >'.price($echeancier->deja_paye).' de ' . price($echeancier->montant) . '</span>';
        print '<span class="echeance ' . $bc[$var] . '">'.$echeancier->count_paye.' sur ' . $echeancier->nombre_echeance . '</span>';
        print '<span class="lastecheance ' . $bc[$var] . '">'.dol_print_date($echeancier->echeances[$echeancier->nombre_echeance -1]['date_reglement']) . '</span>';
        print '<span class= "submit ' . $bc[$var] . '"><input type="submit" id="addelementbuton" class="button" value="' . $langs->trans("modifier") . '"></span></p ></form>';
    }  elseif ($echeancier->type == 1 && $user->rights->echeancier->propale) {
    print '<span class="facture  ' . $bc[$var] . '"><a href="' . DOL_MAIN_URL_ROOT . '/comm/propal.php?id=' . $echeancier->id_element . '">' . $echeancier->ref . '</a></span>';    
    $enable = 'disabled';
       print '<span class="montant ' . $bc[$var] . '" >'. price($echeancier->montant) . '</span>';
    print '<span class="echeance ' . $bc[$var] . '">'. $echeancier->nombre_echeance . '</span>';
     print '<span class="lastecheance ' . $bc[$var] . '">'.dol_print_date($echeancier->echeances[$echeancier->nombre_echeance -1]['date_reglement']) . '</span>';
     print '<span class= "submit ' . $bc[$var] . '"><input type="submit" id="addelementbuton" class="button" value="' . $langs->trans("modifier") . '"></span></p ></form>';
    
    }
 
     
     if ($echeancier->type == 2){
     $montant_total +=  $echeancier->montant;
     $deja_paye += $echeancier->deja_paye;
     $count_paye += $echeancier->count_paye;
     $nombre_echeance += $echeancier->nombre_echeance;
     }
     
     
     
     print '';
    
    
}
$var = !$var;
if ($fact)
print '<p ' . $bc[$var] . ' ><span class="facture ' . $bc[$var] . '"></span><span class="montant ' . $bc[$var] . '" ><br>'.$langs->trans('Total').': '.price($deja_paye).' de '.price($montant_total).'</span><span class="echeance ' . $bc[$var] . '" ><br>'.$count_paye.' sur ' . $nombre_echeance . '</span><span class="lastecheance ' . $bc[$var] . '"></span><span class= "submit ' . $bc[$var] . '"></span></p>';

print '</div></div>';
}