<?php

/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) 2012-2013 jacquel jerome <icfr.eirl@free.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *              \file      
 * 		\ingroup   
 * 		\brief      
 * 		\version    
 * 		\author		jacquel jerome icfr eirl
 * 		
 */
/**
 *  Class of triggers for demo module
 */



class InterfacePaiementEcheances {

    var $db;

    /**
     *   Constructor
     *
     *   @param		DoliDB		$db      Database handler
     */
    function __construct($db) {
        $this->db = $db;

        $this->name = preg_replace('/^Interface/i', '', get_class($this));
        $this->family = "financial";
        $this->description = "EcheancierDescTrigger.";
        $this->version = '1.0';            // 'development', 'experimental', 'dolibarr' or version
        $this->picto = 'technic';
    }

    /**
     *   Return name of trigger file
     *
     *   @return     string      Name of trigger file
     */
    function getName() {
        return $this->name;
    }

    /**
     *   Return description of trigger file
     *
     *   @return     string      Description of trigger file
     */
    function getDesc() {
        return $this->description;
    }

    /**
     *   Return version of trigger file
     *
     *   @return     string      Version of trigger file
     */
    function getVersion() {
        global $langs;
        $langs->load("admin");

        if ($this->version == 'development')
            return $langs->trans("Development");
        elseif ($this->version == 'experimental')
            return $langs->trans("Experimental");
        elseif ($this->version == 'dolibarr')
            return DOL_VERSION;
        elseif ($this->version)
            return $this->version;
        else
            return $langs->trans("Unknown");
    }

    /**
     *      Function called when a Dolibarrr business event is done.
     *      All functions "run_trigger" are triggered if file is inside directory htdocs/core/triggers
     *
     *      @param	string		$action		Event action code
     *      @param  Object		$object     Object
     *      @param  User		$user       Object user
     *      @param  Translate	$langs      Object langs
     *      @param  conf		$conf       Object conf
     *      @return int         			<0 if KO, 0 if no triggered ran, >0 if OK
     */
    function run_trigger($action, $object, $user, $langs, $conf) {

        // Mettre ici le code à exécuter en réaction de l'action
        // Le type de l'évènement Dolibarr est stocké dans $action
        // Les données de l'action sont stockées dans $object
        // La configuration, utilisateur et langage sont dans $conf,$user et $lang
        if ($action == 'PAYMENT_ADD_TO_BANK') {
            include_once DOL_DOCUMENT_ROOT . "/core/lib/date.lib.php";
if (!class_exists('echeancier') && !$res && file_exists(dol_buildpath("/echeancier/class/echeancier.class.php",0)))
    $res = include(dol_buildpath("/echeancier/class/echeancier.class.php",0));
if (!class_exists('echeancier')  && !$res )
    die("Include of echeancier class fails");
            $echeancier = new echeancier($this->db);
            
            
            foreach ($object->amounts as $key => $value) {

                if ($value > 0 && $echeancier->GetEcheancesFromFacture($key, 2)) {
                    $total_amount = $value;
                    $update = FALSE;
                    $echeancier->fetch($echeancier->id);
                    $echeance = new echeance($this->db);
                    $from = date('Y-m-d',dol_get_first_day(date('Y',$object->datepaye), date('m',$object->datepaye)));
                    $to   = date('Y-m-d',dol_get_last_day(date('Y',$object->datepaye), date('m',$object->datepaye)));
                    $echeancesmonth = $echeance->GetEcheanceFromDate($from,$to, $echeancier->id,'desc');
                    $echeances = $echeance->GetEcheances($echeancier->id);
                    $countecheance = count($echeances) - 1 ;
                    $countmonth = count($echeancesmonth);
                    $number_ech = str_pad($echeancier->num + 1, 3, '0', STR_PAD_LEFT);
                    $num = $echeancier->ref_element .'-'. $number_ech;
                    if ($object->num_paiement != '') $num = $num.'('.$object->num_paiement.')';
                    $sql = "update ".MAIN_DB_PREFIX."bank set num_chq='".$num."' where rowid=(select fk_bank from ".MAIN_DB_PREFIX."paiement where rowid=".$object->id.")";
                    $this->db->query($sql);
                    $num = intval($echeancier->num) + 1;

                $sql = "update " . MAIN_DB_PREFIX . "echeancier set num=" . $num . " where id=" . $echeancier->id;

                $this->db->query($sql);
                    for ($i = 0; $i < $countmonth; $i++){
                    $amount = $echeancesmonth[$i]['montant'];
               
                    if (!$echeancesmonth[$i]['paye'] ){
                        
                      $ecart = $echeancesmonth[$i]['montant'] -$echeancesmonth[$i]['montant_paye'] - $total_amount;
                       $paye = ($ecart>0) ? 0 : 1 ;
                      $total_amount = $echeancesmonth[$i]['montant_paye'] + $total_amount;
                        
                     $sql = "update ".MAIN_DB_PREFIX."echeance set montant_paye='".$total_amount."',ecart=".$ecart.", paye=".$paye.", fk_bank=".$object->id." where rowid =".$echeancesmonth[$i]['id'];
                      dol_syslog(get_class($this) . "::update " . $sql, LOG_DEBUG);
                       $this->db->query($sql);
                     $total_amount -= $amount;
                     $update = true;
                     break;
                    } 
                    }
                    if (!$update){
                        $ecart = 0-$total_amount;
                        $sql = "insert into ".MAIN_DB_PREFIX."echeance (fk_echeancier,fk_facture,date_reglement,montant_paye,paye,type,fk_bank,ecart) values(".$echeancier->id.",".$echeancier->id_element.",'".date('Y-m-d',$object->datepaye)."','".$total_amount."',2,2,".$object->id.",$ecart)";
                         dol_syslog(get_class($this) . "::create " . $sql, LOG_DEBUG);
                        $this->db->query($sql);
                        
                        
                    }

                   
                }
            }
            //
           

            
            return 1;
        }
        
        if ($action == 'PAYMENT_DELETE'){
            $sql = "select paye,fk_echeancier from ".MAIN_DB_PREFIX."echeance where fk_bank= ".$object->id;
            $res = $this->db->query($sql);
            if ($res) {
                $obj = $this->db->fetch_object($res);
                $echeancier = $obj->fk_echenacier;
                switch ($obj->paye) {
                    case 1:
                    case 0;
                        $sql = "update ".MAIN_DB_PREFIX."echeance set paye=0,montant_paye=0,ecart=0,fk_bank=0 where fk_bank=".$object->id;
                        break;
                    case 2:
                        $sql = "DELETE FROM ".MAIN_DB_PREFIX."echeance where fk_bank=".$object->id;
                        break;
                    default:
                        
                        break;
                }
                
            }
          
            
           $res = $this->db->query($sql);
           if (!$res) {
               setEventMessage($this->db->lasterror());
           }
             if($echeancier > 0){
            $sql = "UPDATE llx_echeancier set num=(select num -1) where id =".$echeancier;
            $res = $this->db->query($sql);
           if (!$res) {
               setEventMessage($this->db->lasterror());
           }
            }
           
            
        }
        
      
      if ($action == 'BILL_DELETE') {
         $sql = 'DELETE FROM '.MAIN_DB_PREFIX.'echeancier WHERE `type`=2 and id_element = '.$object->id;
         if (!$this->db->query($sql)) 
         return -1;
         
         $sql = 'DELETE FROM '.MAIN_DB_PREFIX.'echeance WHERE fk_facture = '.$object->id;
         if (!$this->db->query($sql)) 
         return -1;
         
      }
    }

}

?>
