<?php

/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) <year>  <name of author>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * 	\file		core/boxes/mybox.php
 * 	\ingroup	mymodule
 * 	\brief		This file is a sample box definition file
 * 				Put some comments here
 */
include_once DOL_DOCUMENT_ROOT . "/core/boxes/modules_boxes.php";
if (!$res && file_exists(dol_buildpath("/echeancier/class/echeancier.class.php",0)))
    $res = include(dol_buildpath("/echeancier/class/echeancier.class.php",0));

if (!$res)
    die("Include of echeancier class fails");

/**
 * Class to manage the box
 */
class box_echeancier extends ModeleBoxes {

    public $boxcode = "Echeancier";
    public $boximg = "generic";
    public $boxlabel;
    public $depends = array("echeancier");
    public $db;
    public $param;
    public $info_box_head = array();
    public $info_box_contents = array();
    public $echeancier;

    /**
     * Constructor
     */
    public function __construct() {
        global $langs;
        $langs->load("echeancier@echeancier");

        $this->boxlabel = $langs->transnoentitiesnoconv("FutureEcheance");
    }

    /**
     * Load data into info_box_contents array to show array later.
     *
     * 	@param		int		$max		Maximum number of records to load
     * 	@return		void
     */
    public function loadBox($max = 5) {
        global $conf, $user, $langs, $db;
        $this->echeancier = new echeance($db);
        if ($user->rights->echeancier->voir){
        $this->max = $max;
        $text = $langs->trans("FutureEcheance", $max);
        $this->info_box_head = array(
            'text' => $text,
            'limit' => dol_strlen($text)
        );
        $month = date("m");
        $year = date("y");
        $j = 0;
            $echeance = $this->echeancier->GetEcheanceFromDate('1970-01-01', date('Y-m-d'));
        foreach ($echeance as $ec){
            if ($ec['type'] == 2){
            $count ++;
            $montant += $ec['montant'];
            }
            
        }
           $this->info_box_contents[0][0] = array('td' => 'align="left"',
                'text' => $langs->trans('Echeance en retard'));
            $this->info_box_contents[0][1] = array('td' => 'align="right"',
                'text' => $count);
            $this->info_box_contents[0][2] = array('td' => 'align="right"',
                'text' => price($montant));
        for ($i = 1; $i < $max ; $i++) {
            if ($month + $i > 12) {
                $month = 1;
                $year = $year + 1;
                $j = 0;
            }
            $echeance = $this->echeancier->GetFuturePaiement($month + $j, $year);
            $this->info_box_contents[$i][0] = array('td' => 'align="left"',
                'text' => dol_print_date(mktime(0, 0, 0, $month + $j +1, 0, $year), '%B %Y'));
            $this->info_box_contents[$i][1] = array('td' => 'align="right"',
                'text' => $echeance['count']);
            $this->info_box_contents[$i][2] = array('td' => 'align="right"',
                'text' => price($echeance['montant']));
            $j++;
        }
    
        
        }

        
    }

    /**
     * 	Method to show box
     *
     * 	@param	array	$head       Array with properties of box title
     * 	@param  array	$contents   Array with properties of box lines
     * 	@return	void
     */
    public function showBox($head = null, $contents = null, $nooutput=0) {
        parent::showBox($this->info_box_head, $this->info_box_contents);
    }

}
