<?php

function updatelines($object, $action)
{
	global $conf,$user,$langs,$mysoc, $hookmanager, $db;

	$element = $object->element;

	// TODO uniformiser
	if ($element == 'propal') $element = 'propale';

	$object->fetch_thirdparty();
	$object->fetch_optionals($object->id);

	// maj taux si currencybilling
	if ($conf->currencybilling->enabled && !empty($object->array_options["options_currency_code"]))
	{
		$currency_rate_var = 'DEFAULT_CURRENCY_RATE_'.$object->array_options["options_currency_code"];
		if (isset($conf->global->$currency_rate_var) ) {
			$object->array_options['options_currency_rate'] = $conf->global->$currency_rate_var;
			$object->insertExtraFields();
		}
	}

	// si location
	if ($conf->rental->enabled && !empty($object->array_options["options_rental_doc"]) && $action != 'updatevat')
	{
		dol_include_once("/rental/lib/rental.lib.php");
		update_rental_lines($object, false);
	}

	$error=0;
	foreach($object->lines as $line)
	{
		if ( ( ! empty($line->array_options["options_rental_line"]) && $action != 'updatevat') ||  ! empty($line->array_options["options_used_line"])) continue;

		if ($line->total_ht == 0 && $action != 'updatevat') continue;

		$idprod = $line->fk_product;
		$qty = $line->qty;

		// get resell discount rate
		$remise_percent = $line->remise_percent;

		if (! empty($idprod))
		{
			if ($action == 'updatevat')
			{
				$pu_ht = $line->subprice;
				$tva_tx = get_default_tva($mysoc, $object->thirdparty, $idprod);
			}
			else
			{
				$prod = new Product($db);
				$prod->fetch($idprod);

				// ne pas mettre à jour les lignes de produits génériques
				$prod->fetch_optionals($idprod);
				if (!empty($prod->array_options['options_generic'])) continue;

				if ($conf->prices->enabled)
				{
					dol_include_once("/prices/class/prices.class.php");
					$price = new ResellPrices($db);
					$price->fetch($idprod);
					$remise_percent = $price->resell_discount_rate;
				}

				$costprice='';
				$pu='';
				$ttc='';

				// extrafields
				$line->fetch_optionals($line->rowid);
				$prod->fetch_optionals($prod->id);
				// mise à jour garantie si module garantie actif
				if ($conf->warranty->enabled && empty($line->array_options["options_garantie"])) {
					$line->array_options["options_garantie"] = $prod->array_options["options_garantie"];
				}

				// Search the correct price into loaded array product_price_by_qty using id of array retrieved into POST['pqp'].
				$pqp = (GETPOST('pbq', 'int') ? GETPOST('pbq', 'int') : 0);

				$datapriceofproduct = $prod->getSellPrice($mysoc, $object->thirdparty, $pqp);

				$pu_ht = $datapriceofproduct['pu_ht'];
				$pu_ttc = $datapriceofproduct['pu_ttc'];
				$price_min = $datapriceofproduct['price_min'];
				$price_base_type = $datapriceofproduct['price_base_type'];
				$tva_tx = $datapriceofproduct['tva_tx'];
				$tva_npr = $datapriceofproduct['tva_npr'];

				$tmpvat = price2num(preg_replace('/\s*\(.*\)/', '', $tva_tx));
				$tmpprodvat = price2num(preg_replace('/\s*\(.*\)/', '', $prod->tva_tx));

				// On reevalue prix selon taux tva car taux tva transaction peut etre different
				// de ceux du produit par defaut (par exemple si pays different entre vendeur et acheteur).
				if ($tmpvat != $tmpprodvat)
				{
					if ($price_base_type != 'HT')
					{
						$pu_ht = price2num($pu_ttc / (1 + ($tmpvat / 100)), 'MU');
					}
					else
					{
						$pu_ttc = price2num($pu_ht * (1 + ($tmpvat / 100)), 'MU');
					}
				}

				/* setup of margin calculation */
				if (isset($conf->global->MARGIN_TYPE))
				{
					// default is fournprice
					require_once DOL_DOCUMENT_ROOT.'/fourn/class/fournisseur.product.class.php';
					$pf = new ProductFournisseur($db);
					if ($pf->find_min_price_product_fournisseur($idprod, $qty) > 0)
					{
						$line->fk_fournprice = $pf->product_fourn_price_id;
						$line->pa_ht = $pf->fourn_price * (1 - $pf->fourn_remise_percent / 100);
						if ($pf->fourn_charges > 0)
							$line->pa_ht += $pf->fourn_charges / $pf->fourn_qty;
					}

					if ($conf->global->MARGIN_TYPE == 'pmp' && ! empty($pf->pmp))
					{
						$line->fk_fournprice = null;
						$line->pa_ht = $pf->pmp;
					}
					elseif ($conf->global->MARGIN_TYPE == 'costprice' && ! empty($pf->cost_price))
					{
						$line->fk_fournprice = null;
						$line->pa_ht = $pf->cost_price;
					}
				}
			}

			$localtax1_rate=get_localtax($tva_tx,1,$object->thirdparty);
			$localtax2_rate=get_localtax($tva_tx,2,$object->thirdparty);
		}
		elseif (!empty($object->thirdparty->array_options['options_vat_exempted']) && empty($line->special_code))
		{
			$pu_ht = $line->subprice;
			$tva_tx = 0;
			$localtax1_rate=get_localtax($tva_tx,1,$object->thirdparty);
			$localtax2_rate=get_localtax($tva_tx,2,$object->thirdparty);
		}
		else
		{
			$pu_ht = $line->subprice;
			$tva_tx = get_default_tva($mysoc, $object->thirdparty);
			$localtax1_rate=get_localtax($tva_tx,1,$object->thirdparty);
			$localtax2_rate=get_localtax($tva_tx,2,$object->thirdparty);
		}

		// mise à jour
		if ($element == 'propale')
		{
			$result = $object->updateline(
				$line->rowid,
				$pu_ht,
				$qty,
				$remise_percent,
				$tva_tx,
				$localtax1_rate,
				$localtax2_rate,
				$line->desc,
				'HT',
				$line->info_bits,
				$line->special_code,
				$line->fk_parent_line,
				0,
				$line->fk_fournprice,
				$line->pa_ht,
				$line->label,
				$line->product_type,
				$line->date_start,
				$line->date_end,
				$line->array_options,
				$line->fk_unit
			);

			if ($result >= 0)
			{

			}
			else
			{
				setEventMessage($object->error, 'errors');
			}
		}
		elseif($element == 'commande')
		{
			$result = $object->updateline(
					$line->rowid,
					$line->desc,
					$pu_ht,
					$qty,
					$remise_percent,
					$tva_tx,
					$localtax1_rate,
					$localtax2_rate,
					'HT',
					$line->info_bits,
					$line->date_start,
					$line->date_end,
					$line->product_type,
					$line->fk_parent_line,
					0,
					$line->fk_fournprice,
					$line->pa_ht,
					$line->label,
					0,
					$line->array_options,
					$line->fk_unit
			);

			if ($result >= 0)
			{


			}
			else
			{
				setEventMessage($object->error, 'errors');
			}
		}
		elseif ($element == 'facture')
		{
			$result = $object->updateline(
					$line->rowid,
					$line->desc,
					$pu_ht,
					$qty,
					$remise_percent,
					$line->date_start,
					$line->date_end,
					$tva_tx,
					$localtax1_rate,
					$localtax2_rate,
					'HT',
					$line->info_bits,
					$line->fk_product_type,
					$line->fk_parent_line,
					0,
					$line->fk_fournprice,
					$line->pa_ht,
					$line->label,
					0,
					$line->array_options,
					$line->situation_percent,
					$line->fk_unit
			);

			if ($result >= 0)
			{
			}
			else
			{
				setEventMessage($object->error, 'errors');
			}
		}
	}

	if (empty($conf->global->MAIN_DISABLE_PDF_AUTOUPDATE))
	{
		// Define output language
		$outputlangs = $langs;
		if (! empty($conf->global->MAIN_MULTILANGS))
		{
			$outputlangs = new Translate("",$conf);
			$newlang=(GETPOST('lang_id') ? GETPOST('lang_id') : $object->thirdparty->default_lang);
			$outputlangs->setDefaultLang($newlang);
		}

		$object->fetch($object->id);    // Reload to get new records
		$object->fetch_thirdparty();

		//PDF
		switch($element)
		{
			case 'propale':
				$modele = $conf->global->PROPALE_ADDON_PDF;
				break;
			case 'commande':
				$modele = $conf->global->COMMANDE_ADDON_PDF;
				break;
			case 'facture' :
				$modele = $conf->global->FACTURE_ADDON_PDF;
				break;
		}

		$hidedetails = (GETPOST('hidedetails','int') ? GETPOST('hidedetails','int') : (! empty($conf->global->MAIN_GENERATE_DOCUMENTS_HIDE_DETAILS) ? 1 : 0));
		$hidedesc 	 = (GETPOST('hidedesc','int') ? GETPOST('hidedesc','int') : (! empty($conf->global->MAIN_GENERATE_DOCUMENTS_HIDE_DESC) ?  1 : 0));
		$hideref 	 = (GETPOST('hideref','int') ? GETPOST('hideref','int') : (! empty($conf->global->MAIN_GENERATE_DOCUMENTS_HIDE_REF) ? 1 : 0));

		$object->generateDocument($modele, $outputlangs, $hidedetails, $hidedesc, $hideref, $moreparams);
	}
}
