<?php
/* Copyright (C) 2019 Alice Adminson
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file    dolitools/lib/dolitools.lib.php
 * \ingroup dolitools
 * \brief   Library files with common functions for Dolitools
 */

/**
 * Prepare admin pages header
 *
 * @return array
 */
function dolitoolsAdminPrepareHead()
{
	global $langs, $conf;

	$langs->loadLangs(array("dolitools@dolitools", "customref@dolitools", "tricks@dolitools"));

	$h = 0;
	$head = array();

	$head[$h][0] = dol_buildpath("/dolitools/admin/setup.php", 1);
	$head[$h][1] = $langs->trans("MainSetup");
	$head[$h][2] = 'settings';
	$h++;

	if ( ! empty($conf->global->DOLITOOLS_USE_ALTATHEME) )
	{
		$head[$h][0] = dol_buildpath("/dolitools/admin/altatheme.php", 1);
		$head[$h][1] = $langs->trans("Theme");
		$head[$h][2] = 'altatheme';
		$h++;
	}

	if ( ! empty($conf->global->DOLITOOLS_USE_ALTATPL) )
	{
		$head[$h][0] = dol_buildpath("/dolitools/admin/altatpl.php", 1);
		$head[$h][1] = $langs->trans("Templates");
		$head[$h][2] = 'altatpl';
		$h++;
	}

	if ( ! empty($conf->global->DOLITOOLS_USE_CUSTOMREF) )
	{
		$head[$h][0] = dol_buildpath("/dolitools/admin/customref.php", 1);
		$head[$h][1] = $langs->trans("CustomRef");
		$head[$h][2] = 'customref';
		$h++;
	}

	if ( ! empty($conf->global->DOLITOOLS_DISPLAY_TRICKS) )
	{
		$head[$h][0] = dol_buildpath("/dolitools/admin/tricks.php", 1);
		$head[$h][1] = $langs->trans("Tricks");
		$head[$h][2] = 'tricks';
		$h++;
	}

	$head[$h][0] = dol_buildpath("/dolitools/admin/about.php", 1);
	$head[$h][1] = $langs->trans("About");
	$head[$h][2] = 'about';
	$h++;

	// Show more tabs from modules
	// Entries must be declared in modules descriptor with line
	//$this->tabs = array(
	//	'entity:+tabname:Title:@dolitools:/dolitools/mypage.php?id=__ID__'
	//); // to add new tab
	//$this->tabs = array(
	//	'entity:-tabname:Title:@dolitools:/dolitools/mypage.php?id=__ID__'
	//); // to remove a tab
	complete_head_from_modules($conf, $langs, $object, $head, $h, 'dolitools');

	return $head;
}
