<?php

/**
 *    stock dispo = stock reel - commandes
 *
 *    @return   int             < 0 if KO, > 0 if OK
 *    @see		load_stock, getBatchInfo
 */
function load_available_stock(&$product)
{
	global $conf;

	// commented by christophe battarelif ( ! isset($product->stock_available))
	// always recalculate available stock in case of bad value or change in setup...
	update_available_stock($product);

	return $product->stock_available;
}


/**
 *    stock dispo = stock reel - commandes
 *
 *    @return   int             < 0 if KO, > 0 if OK
 *    @see		load_stock, getBatchInfo
 */
function update_available_stock(&$product)
{
	global $conf, $db;

	$stock_commande_client=0;
	$stock_sending_client=0;

	if ( ! empty($conf->rental->enabled))
	{
		dol_include_once('/rental/lib/rental.lib.php');
		$stock = get_sell_stock($product->id); //print '<br>stock : '.$stock;
	}
	else
	{
		// INUTILE ET RALLONGE TEMPS DE CALCUL $product->load_stock('novirtual');
		$stock = $product->stock_reel?$product->stock_reel:"0";
	}

	if ( ! empty($conf->occasions->enabled))
	{
		dol_include_once('/occasions/lib/occasions.lib.php');
		$stock -= get_available_used_stock($product);
	}

	if (! empty($conf->commande->enabled))
	{
		$stock_commande_client=get_qty_commande($product);//print '<br>stock_commande_client : '.$stock_commande_client;
	}
	if (! empty($conf->expedition->enabled))
	{
		$stock_sending_client=get_qty_send($product);//print '<br>stock_sending_client : '.$stock_sending_client;
	}

	// Stock decrease mode
	if (! empty($conf->global->STOCK_CALCULATE_ON_SHIPMENT) || ! empty($conf->global->STOCK_CALCULATE_ON_SHIPMENT_CLOSE)) {
		$product->stock_available=$stock-$stock_commande_client+$stock_sending_client;
	}
	elseif (! empty($conf->global->STOCK_CALCULATE_ON_VALIDATE_ORDER)) {
		$product->stock_available=$stock;
	}
	elseif (! empty($conf->global->STOCK_CALCULATE_ON_BILL)) {
		$product->stock_available=$stock-$stock_commande_client;
	}

	$result  = $db->db->query("update ".MAIN_DB_PREFIX."product set stock_available = ".$product->stock_available ." where rowid = ".$product->id);

}

    function get_qty_send($product, $filter=null)
    {
        // phpcs:enable
        global $conf,$user,$db;

        $sql = "SELECT SUM(ed.qty) as qty";
        $sql.= " FROM ".MAIN_DB_PREFIX."expeditiondet as ed";
        $sql.= " LEFT JOIN ".MAIN_DB_PREFIX."commandedet as cd ON ed.fk_origin_line = cd.rowid";

         if ((! empty($conf->rental->enabled) && empty($conf->global->AVAILABLESTOCK_NO_RENTAL)) || ! empty($conf->occasions->enabled)) $sql.= " LEFT JOIN ".MAIN_DB_PREFIX."commandedet_extrafields as cde ON cde.fk_object = cd.rowid";

        $sql.= ", ".MAIN_DB_PREFIX."commande as c";

        if (!empty($conf->rental->enabled) && ! empty($conf->global->AVAILABLESTOCK_NO_RENTAL)) $sql.= " LEFT JOIN ".MAIN_DB_PREFIX."commande_extrafields as ce ON ce.fk_object = c.rowid";

        $sql.= ", ".MAIN_DB_PREFIX."expedition as e";
        $sql.= " WHERE e.rowid = ed.fk_expedition AND e.fk_statut > 0";
        $sql.= " AND c.rowid = cd.fk_commande";
        $sql.= " AND e.entity IN (".getEntity('expedition').")";
        $sql.= " AND cd.fk_product = ".$product->id;
		if (!empty($conf->rental->enabled))
		{
			if (empty($conf->global->AVAILABLESTOCK_NO_RENTAL)) $sql.= " AND (cde.rental_line = 0 or cde.rental_line is null)";
			else $sql.= " AND (ce.rental_doc = 0 or ce.rental_doc is null)";
		}
        $sql.= " AND c.fk_statut in (1,2)";

        if (! empty($filter)) $sql.=" ".$filter;

        $result = $db->query($sql);
        if ($result ) {
            $obj=$db->fetch_object($result);
            $qty=$obj->qty?$obj->qty:0;
			// check if child of product
			$parents = $product->getFather();
			foreach($parents as $pa_id => $parent)
			{
				$prod = new Product($db);
				$prod->fetch($parent['id']);
				$qty+=(get_qty_send($prod, $filter) * $parent['qty']);
			}
            return $qty;
        }
        else
        {
            return -1;
        }
    }

    function get_qty_commande($product, $filter=null)
    {
        // phpcs:enable
        global $conf,$user,$db;

        $sql = "SELECT SUM(cd.qty) as qty";
        $sql.= " FROM ".MAIN_DB_PREFIX."commandedet as cd";

        if ((! empty($conf->rental->enabled) && empty($conf->global->AVAILABLESTOCK_NO_RENTAL)) || ! empty($conf->occasions->enabled)) $sql.= " LEFT JOIN ".MAIN_DB_PREFIX."commandedet_extrafields as cde ON cde.fk_object = cd.rowid";

        $sql.= ", ".MAIN_DB_PREFIX."commande as c";

        if (!empty($conf->rental->enabled) && ! empty($conf->global->AVAILABLESTOCK_NO_RENTAL)) $sql.= " LEFT JOIN ".MAIN_DB_PREFIX."commande_extrafields as ce ON ce.fk_object = c.rowid";

        $sql.= " WHERE c.rowid = cd.fk_commande";
        $sql.= " AND c.entity IN (".getEntity('commande').")";
        $sql.= " AND cd.fk_product = ".$product->id;

		if (!empty($conf->rental->enabled))
		{
			if (empty($conf->global->AVAILABLESTOCK_NO_RENTAL)) $sql.= " AND (cde.rental_line = 0 or cde.rental_line is null)";
			else $sql.= " AND (ce.rental_doc = 0 or ce.rental_doc is null)";
		}

        $sql.= " AND c.fk_statut in (0,1,2)";

        if (! empty($filter)) $sql.=" ".$filter;

        $result = $db->query($sql);
        if ($result ) {
            $obj=$db->fetch_object($result);
            $qty=$obj->qty?$obj->qty:0;

            // if it's a virtual product, maybe it is in order by extension
            if (! empty($conf->global->ORDER_ADD_ORDERS_WITH_PARENT_PROD_IF_INCDEC)) {
                $TFather = $product->getFather();
                if (is_array($TFather) && !empty($TFather)) {
                    foreach($TFather as &$fatherData) {
                        $pFather = new Product($db);
                        $pFather->id = $fatherData['id'];
                        $qtyCoef = $fatherData['qty'];

                        if ($fatherData['incdec']) {
                            $qty+=get_qty_commande($pFather, $filter) * $qtyCoef;
                        }
                    }
                }
            }

            // If stock decrease is on invoice validation, the theorical stock continue to
            // count the orders to ship in theorical stock when some are already removed b invoice validation.
            // If option DECREASE_ONLY_UNINVOICEDPRODUCTS is on, we make a compensation.
            if (! empty($conf->global->STOCK_CALCULATE_ON_BILL)) {
                if (! empty($conf->global->DECREASE_ONLY_UNINVOICEDPRODUCTS)) {
                    $adeduire = 0;
                    $sql = "SELECT sum(fd.qty) as count FROM ".MAIN_DB_PREFIX."facturedet fd ";
                    $sql .= " JOIN ".MAIN_DB_PREFIX."facture f ON fd.fk_facture = f.rowid ";
                    $sql .= " JOIN ".MAIN_DB_PREFIX."element_element el ON el.fk_target = f.rowid and el.targettype = 'facture' and sourcetype = 'commande'";
                    $sql .= " JOIN ".MAIN_DB_PREFIX."commande c ON el.fk_source = c.rowid ";

					if (!empty($conf->rental->enabled))
					{
						if (empty($conf->global->AVAILABLESTOCK_NO_RENTAL)) $sql.= " LEFT JOIN ".MAIN_DB_PREFIX."facturedet_extrafields as fde ON fde.fk_object = fd.rowid";
						else  $sql.= " LEFT JOIN ".MAIN_DB_PREFIX."facture_extrafields as fe ON fe.fk_object = f.rowid";
					}

                    $sql .= " WHERE c.fk_statut IN (0,1,2) AND c.facture = 0 AND fd.fk_product = ".$product->id;

					if (!empty($conf->rental->enabled))
					{
						if (empty($conf->global->AVAILABLESTOCK_NO_RENTAL)) $sql.= " AND (fde.rental_line = 0 or fde.rental_line is null)";
						else  $sql.= " AND (fe.rental_doc = 0 or fe.rental_doc is null)";
					}

					if (! empty($filter)) $sql.=" ".$filter;

                    dol_syslog(__METHOD__.":: sql $sql", LOG_NOTICE);

                    $resql = $db->query($sql);
                    if ($resql ) {
                        if ($db->num_rows($resql) > 0) {
                            $obj = $db->fetch_object($resql);
                            $adeduire += $obj->count;
                        }
                    }

                    $qty -= $adeduire;
                }
            }

            return $qty;
        }
        else
        {
            return -1;
        }
    }

    function get_stock_for_line($fk_product, $options)
    {
		global $conf, $db;

		if ( ! empty($conf->occasions->enabled)) dol_include_once('/occasions/lib/occasions.lib.php');

		$stock = 0;

		require_once DOL_DOCUMENT_ROOT . '/product/class/product.class.php';
		$product = new Product($db);
		if ($product->fetch($fk_product) > 0)
		{
			if ( ! empty($options['options_used_line']))
			{
				$stock = get_available_used_stock($product);
			}
			elseif (empty($options['options_rental_line']))
			{
				if ($conf->global->USE_AVAILABLE_STOCK) {
					$stock = load_available_stock($product);
				}
				else
				{
					$product->load_stock();

					$stock = $product->stock_reel?$product->stock_reel:"0";

					if (!empty($conf->rental->enabled))
						$stock = get_sell_stock($fk_product);

					elseif ($conf->global->USE_VIRTUAL_STOCK) {
						$product->load_virtual_stock();
						$stock = $product->stock_theorique;
					}

					if ( ! empty($conf->occasions->enabled)) $stock -= get_used_stock($product->id);

				}
			}
		}

		return $stock;
	}
