<?php
/* Copyright (C) 2016 altairis <contact@altairis.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *  \file       htdocs/core/triggers/interface_90_all_Visuals.class.php
 *  \ingroup    prices
 *  \brief      Fichier de définition des triggers du module Visuals
 *  \remarks    Triggers pris en charge :
 *              - PRODUCT_DELETE : suppression des prix du produit supprimé
 */


/**
 *  Class of triggers for Altatpl module
 */
class InterfaceAltatpl
{
    var $db;

    /**
     *   Constructor
     *
     *   @param		DoliDB		$db      Database handler
     */
    function __construct($db)
    {
		global $conf;

        $this->db = $db;

        $this->name = preg_replace('/^Interface/i','',get_class($this));
        $this->family = "Dolitools";
        $this->description = "Dolitools triggers.";
        $this->version = 'dolibarr';            // 'development', 'experimental', 'dolibarr' or version
        $this->picto = 'altairis@dolitools';
    }


    /**
     *   Return name of trigger file
     *
     *   @return     string      Name of trigger file
     */
    function getName()
    {
        return $this->name;
    }

    /**
     *   Return description of trigger file
     *
     *   @return     string      Description of trigger file
     */
    function getDesc()
    {
        return $this->description;
    }

    /**
     *   Return version of trigger file
     *
     *   @return     string      Version of trigger file
     */
    function getVersion()
    {
        global $langs;
        $langs->load("admin");

        if ($this->version == 'development') return $langs->trans("Development");
        elseif ($this->version == 'experimental') return $langs->trans("Experimental");
        elseif ($this->version == 'dolibarr') return DOL_VERSION;
        elseif ($this->version) return $this->version;
        else return $langs->trans("Unknown");
    }

    /**
     *      Function called when a Dolibarrr business event is done.
     *      All functions "run_trigger" are triggered if file is inside directory htdocs/core/triggers
     *
     *      @param	string		$action		Event action code
     *      @param  Object		$object     Object
     *      @param  User		$user       Object user
     *      @param  Translate	$langs      Object langs
     *      @param  conf		$conf       Object conf
     *      @return int         			<0 if KO, 0 if no triggered ran, >0 if OK
     */
	function run_trigger($action,$object,$user,$langs,$conf)
	{
		if (empty($conf->global->DOLITOOLS_USE_ALTATPL)) return;

		if ( $action == 'LINEPROPAL_INSERT' ||  $action == 'LINEPROPAL_UPDATE' ||  $action == 'LINEPROPAL_DELETE' )
        {
            dol_syslog("Trigger '".$this->name."' for action '$action' launched by ".__FILE__.". id=".$object->id);
            return $this->linepropal_rank($action,$object,$user,$langs,$conf);
        }

		if ( $action == 'LINEORDER_INSERT'||  $action == 'LINEORDER_UPDATE' ||  $action == 'LINEORDER_DELETE' )
        {
            dol_syslog("Trigger '".$this->name."' for action '$action' launched by ".__FILE__.". id=".$object->id);
            return $this->lineorder_rank($action,$object,$user,$langs,$conf);
        }

		if ( $action == 'LINEBILL_INSERT'||  $action == 'LINEBILL_UPDATE' ||  $action == 'LINEBILL_DELETE' )
        {
            dol_syslog("Trigger '".$this->name."' for action '$action' launched by ".__FILE__.". id=".$object->id);
            return $this->linebill_rank($action,$object,$user,$langs,$conf);
        }

		if ( $action == 'LINEORDER_SUPPLIER_CREATE'||  $action == 'LINEORDER_SUPPLIER_UPDATE' ||  $action == 'LINEORDER_SUPPLIER_DELETE' )
        {
            dol_syslog("Trigger '".$this->name."' for action '$action' launched by ".__FILE__.". id=".$object->id);
            return $this->linesupplierorder_rank($action,$object,$user,$langs,$conf);
        }

		if ( $action == 'LINESUPPLIER_PROPOSAL_INSERT'||  $action == 'LINESUPPLIER_PROPOSAL_UPDATE' ||  $action == 'LINESUPPLIER_PROPOSAL_DELETE' )
        {
            dol_syslog("Trigger '".$this->name."' for action '$action' launched by ".__FILE__.". id=".$object->id);
            return $this->linesupplierproposal_rank($action,$object,$user,$langs,$conf);
        }

		if ( $action == 'LINEBILL_SUPPLIER_CREATE'||  $action == 'LINEBILL_SUPPLIER_UPDATE' ||  $action == 'LINEBILL_SUPPLIER_DELETE' )
        {
            dol_syslog("Trigger '".$this->name."' for action '$action' launched by ".__FILE__.". id=".$object->id);
            return $this->linesupplierbill_rank($action,$object,$user,$langs,$conf);
        }

		return 0;
    }

    function linepropal_rank($action,$object,$user,$langs,$conf)
    {
		$rank = GETPOST('rank','int')?GETPOST('rank','int'):GETPOST('rank_predef','int');

		if ( ! is_numeric($rank)  && $action != 'LINEPROPAL_DELETE') return;

		if ($rank > 0)
		{
			if ($action == 'LINEPROPAL_INSERT') $rank -= 1;
		}

		if ($rank >= 0 || $action == 'LINEPROPAL_DELETE')
		{
			if ($action == 'LINEPROPAL_UPDATE') $object->fetch($object->id);

			$doc = new Propal($this->db);
			$doc->fetch($object->fk_propal);

			if ($action != 'LINEPROPAL_DELETE')
			{
				$sql = "update ".MAIN_DB_PREFIX."propaldet set rang = ".$rank." where rowid = ".$object->id;
				$this->db->query($sql);
				$object->rang = $rank;
			}

			$doc->line_order(false);
			$doc->line_order(true);
		}
	}

    function lineorder_rank($action,$object,$user,$langs,$conf)
    {
		global $conf, $draftupdate;

		if ($draftupdate)
		{
			$rank = GETPOST('rank_'.$object->id);
		}
		else
		{
			$rank = GETPOST('rank','int')?GETPOST('rank','int'):GETPOST('rank_predef','int');
		}

		if ( ! is_numeric($rank)  && $action != 'LINEORDER_DELETE') return;

		if ($rank > 0)
		{
			if ($action == 'LINEORDER_INSERT') $rank -= 1;
		}

		if ($rank >= 0 || $action == 'LINEORDER_DELETE')
		{
			if ($action != 'LINEORDER_DELETE')
			{
				$sql = "update ".MAIN_DB_PREFIX."commandedet set rang = ".$rank." where rowid = ".$object->id;
				$this->db->query($sql);
			}

			if ( ! $draftupdate )
			{
				if ($action == 'LINEORDER_UPDATE') $object->fetch($object->id);
				$doc = new Commande($this->db);
				$doc->fetch($object->fk_commande);

				$doc->line_order(false);
				$doc->line_order(true);
			}
		}

	}


    function linebill_rank($action,$object,$user,$langs,$conf)
    {
		$rank = GETPOST('rank','int')?GETPOST('rank','int'):GETPOST('rank_predef','int');

		if ( ! is_numeric($rank)  && $action != 'LINEBILL_DELETE') return;

		if ($rank > 0)
		{
			if ($action == 'LINEBILL_INSERT') $rank -= 1;
		}

		if ($rank >= 0 || $action == 'LINEBILL_DELETE')
		{
			if ($action == 'LINEBILL_UPDATE') $object->fetch($object->id);

			$doc = new Facture($this->db);
			$doc->fetch($object->fk_facture);

			if ($action != 'LINEBILL_DELETE')
			{
				$sql = "update ".MAIN_DB_PREFIX."facturedet set rang = ".$rank." where rowid = ".$object->id;
				$this->db->query($sql);
			}

			$doc->line_order(false);
			$doc->line_order(true);
		}
	}

    function linesupplierorder_rank($action,$object,$user,$langs,$conf)
    {
		global $conf;

		$rank = GETPOST('rank','int')?GETPOST('rank','int'):GETPOST('rank_predef','int');

		if ( ! is_numeric($rank)  && $action != 'LINEORDER_SUPPLIER_DELETE') return;

		if ($rank > 0)
		{
			if ($action == 'LINEORDER_SUPPLIER_CREATE') $rank -= 1;
		}

		if ($rank >= 0 || $action == 'LINEORDER_SUPPLIER_DELETE')
		{
			if ($action == 'LINEORDER_SUPPLIER_UPDATE') $object->fetch($object->id);

			$doc = new CommandeFournisseur($this->db);
			$doc->fetch($object->fk_commande);

			if ($action != 'LINEORDER_SUPPLIER_DELETE')
			{
				$sql = "update ".MAIN_DB_PREFIX."commande_fournisseurdet set rang = ".$rank." where rowid = ".$object->id;
				$this->db->query($sql);
			}

			$doc->line_order(false);
			$doc->line_order(true);
		}

	}

    function linesupplierproposal_rank($action,$object,$user,$langs,$conf)
    {
		global $conf;

		$rank = GETPOST('rank','int')?GETPOST('rank','int'):GETPOST('rank_predef','int');

		if ( ! is_numeric($rank)  && $action != 'LINESUPPLIER_PROPOSAL_DELETE') return;

		if ($rank > 0)
		{
			if ($action == 'LINESUPPLIER_PROPOSAL_INSERT') $rank -= 1;
		}

		if ($rank >= 0 || $action == 'LINESUPPLIER_PROPOSAL_DELETE')
		{
			if ($action == 'LINESUPPLIER_PROPOSAL_UPDATE') $object->fetch($object->id);

			$doc = new SupplierProposal($this->db);
			$doc->fetch($object->fk_supplier_proposal);

			if ($action != 'LINESUPPLIER_PROPOSAL_DELETE')
			{
				$sql = "update ".MAIN_DB_PREFIX."supplier_proposaldet set rang = ".$rank." where rowid = ".$object->id;
				$this->db->query($sql);
			}

			$doc->line_order(false);
			$doc->line_order(true);
		}

	}

    function linesupplierbill_rank($action,$object,$user,$langs,$conf)
    {
		global $conf;

		$rank = GETPOST('rank','int')?GETPOST('rank','int'):GETPOST('rank_predef','int');

		if ( ! is_numeric($rank)  && $action != 'LINEBILL_SUPPLIER_DELETE') return;

		if ($rank > 0)
		{
			if ($action == 'LINEBILL_SUPPLIER_CREATE') $rank -= 1;
		}

		if ($rank >= 0 || $action == 'LINEBILL_SUPPLIER_DELETE')
		{
			if ($action == 'LINEBILL_SUPPLIER_UPDATE') $object->fetch($object->id);

			$doc = new FactureFournisseur($this->db);
			$doc->fetch($object->fk_facture_fourn);

			if ($action != 'LINEBILL_SUPPLIER_DELETE')
			{
				$sql = "update ".MAIN_DB_PREFIX."facture_fourn_det set rang = ".$rank." where rowid = ".$object->id;
				$this->db->query($sql);
			}

			$doc->line_order(false);
			$doc->line_order(true);
		}

	}


}
?>
