<?php
/* Copyright (C) 2013  altairis <contact@altairis.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *  \file       htdocs/core/triggers/interface_90_all_Prices.class.php
 *  \ingroup    prices
 *  \brief      Fichier de définition des triggers du module Prices
 *  \remarks    Triggers pris en charge :
 *              - PRODUCT_DELETE : suppression des prix du produit supprimé
 */

/**
 *  Class of triggers for Prices module
 */
class InterfaceGlobaldiscount
{
    var $db;

    /**
     *   Constructor
     *
     *   @param		DoliDB		$db      Database handler
     */
    function __construct($db)
    {
        $this->db = $db;

        $this->name = preg_replace('/^Interface/i','',get_class($this));
        $this->family = "Currencybilling";
        $this->description = "Fichier de définition des triggers du module Currencybilling";
        $this->version = 'dolibarr';            // 'development', 'experimental', 'dolibarr' or version
        $this->picto = 'technic';
    }


    /**
     *   Return name of trigger file
     *
     *   @return     string      Name of trigger file
     */
    function getName()
    {
        return $this->name;
    }

    /**
     *   Return description of trigger file
     *
     *   @return     string      Description of trigger file
     */
    function getDesc()
    {
        return $this->description;
    }

    /**
     *   Return version of trigger file
     *
     *   @return     string      Version of trigger file
     */
    function getVersion()
    {
        global $langs;
        $langs->load("admin");

        if ($this->version == 'development') return $langs->trans("Development");
        elseif ($this->version == 'experimental') return $langs->trans("Experimental");
        elseif ($this->version == 'dolibarr') return DOL_VERSION;
        elseif ($this->version) return $this->version;
        else return $langs->trans("Unknown");
    }

    /**
     *      Function called when a Dolibarrr business event is done.
     *      All functions "run_trigger" are triggered if file is inside directory htdocs/core/triggers
     *
     *      @param	string		$action		Event action code
     *      @param  Object		$object     Object
     *      @param  User		$user       Object user
     *      @param  Translate	$langs      Object langs
     *      @param  conf		$conf       Object conf
     *      @return int         			<0 if KO, 0 if no triggered ran, >0 if OK
     */
	function run_trigger($action,$object,$user,$langs,$conf)
    {
		$element = $object->element;
		if ($element == 'propal') $element = 'propale';

        if (($action == 'PROPAL_MODIFY' || $action == 'ORDER_MODIFY' || $action == 'BILL_MODIFY'))
        {
			$discount_update = GETPOST('draftupdate') && GETPOST('options_global_discount') != $object->oldarray_options['options_global_discount'];
            if ( ! empty($object->context['extrafieldaddupdate']) && ( GETPOST('attribute') == 'global_discount'
				|| $discount_update ) )
            {
				if (GETPOST('options_global_discount')) $object->array_options['options_global_discount'] = price2num(GETPOST('options_global_discount'));

				// maj des lignes
				foreach($object->lines as $line)
				{
					if ( ! empty($line->special_code)) continue;

					$line->fetch_optionals($line->rowid);

					if ( ! empty($object->array_options['options_rental_doc']) && empty($line->array_options['options_rental_line']) && ! empty($conf->global->DOLITOOLS_NO_GLOBAL_DISCOUNT_ON_RENTAL_SALES)) continue; // pas les lignes de vente sur doc location

					if ( ! empty($line->array_options['options_rental_line']) && (price2num($line->pa_ht) == price2num($line->subprice * (1 - $line->remise_percent / 100) + ($line->array_options['options_rental_warranty_price']?($line->array_options['options_rental_warranty_price'] * $line->remise_percent / 100):0))))
					{

						$line->remise_percent = $object->array_options['options_global_discount'];
						$line->pa_ht = $line->subprice * (1 - $line->remise_percent / 100) + ($line->array_options['options_rental_warranty_price']?($line->array_options['options_rental_warranty_price'] * $line->remise_percent / 100):0);
					}
					else
					{
						$line->remise_percent = $object->array_options['options_global_discount'];
					}

					// mise à jour
					if ($element == 'propale')
					{
						$result = $object->updateline(
							$line->rowid,
							$line->subprice,
							$line->qty,
							$line->remise_percent,
							$line->tva_tx,
							$line->localtax1_tx,
							$line->localtax1_tx,
							$line->desc,
							'HT',
							$line->info_bits,
							$line->special_code,
							$line->fk_parent_line,
							0,
							$line->fk_fournprice,
							$line->pa_ht,
							$line->label,
							$line->product_type,
							$line->date_start,
							$line->date_end,
							$line->array_options,
							$line->fk_unit
						);

						if ($result >= 0)
						{

						}
						else
						{
							setEventMessage($object->error, 'errors');
						}
					}
					elseif($element == 'commande')
					{
						$result = $object->updateline(
								$line->rowid,
								$line->desc,
								$line->subprice,
								$line->qty,
								$line->remise_percent,
								$line->tva_tx,
								$line->localtax1_tx,
								$line->localtax1_tx,
								'HT',
								$line->info_bits,
								$line->date_start,
								$line->date_end,
								$line->product_type,
								$line->fk_parent_line,
								0,
								$line->fk_fournprice,
								$line->pa_ht,
								$line->label,
								0,
								$line->array_options,
								$line->fk_unit
						);

						if ($result >= 0)
						{


						}
						else
						{
							setEventMessage($object->error, 'errors');
						}
					}
					elseif ($element == 'facture')
					{
						$result = $object->updateline(
								$line->rowid,
								$line->desc,
								$line->subprice,
								$line->qty,
								$line->remise_percent,
								$line->date_start,
								$line->date_end,
								$line->tva_tx,
								$line->localtax1_tx,
								$line->localtax1_tx,
								'HT',
								$line->info_bits,
								$line->fk_product_type,
								$line->fk_parent_line,
								0,
								$line->fk_fournprice,
								$line->pa_ht,
								$line->label,
								0,
								$line->array_options,
								$line->fk_unit
						);

						if ($result >= 0)
						{
						}
						else
						{
							setEventMessage($object->error, 'errors');
						}
					}
				}

				if (empty($conf->global->MAIN_DISABLE_PDF_AUTOUPDATE))
				{
					// Define output language
					$outputlangs = $langs;
					if (! empty($conf->global->MAIN_MULTILANGS))
					{
						$object->fetch_thirdparty();
						$outputlangs = new Translate("",$conf);
						$newlang=(GETPOST('lang_id') ? GETPOST('lang_id') : $object->thirdparty->default_lang);
						$outputlangs->setDefaultLang($newlang);
					}

					//PDF
					$hidedetails = (GETPOST('hidedetails','int') ? GETPOST('hidedetails','int') : (! empty($conf->global->MAIN_GENERATE_DOCUMENTS_HIDE_DETAILS) ? 1 : 0));
					$hidedesc 	 = (GETPOST('hidedesc','int') ? GETPOST('hidedesc','int') : (! empty($conf->global->MAIN_GENERATE_DOCUMENTS_HIDE_DESC) ?  1 : 0));
					$hideref 	 = (GETPOST('hideref','int') ? GETPOST('hideref','int') : (! empty($conf->global->MAIN_GENERATE_DOCUMENTS_HIDE_REF) ? 1 : 0));

					$object->generateDocument($object->modelpdf, $outputlangs, $hidedetails, $hidedesc, $hideref, $moreparams);
				}
            }

		}

        return 0;
    }

}
?>
