<?php
/* Copyright (C) 2010-2013	Regis Houssin		<regis.houssin@inodbox.com>
 * Copyright (C) 2010-2011	Laurent Destailleur	<eldy@users.sourceforge.net>
 * Copyright (C) 2012-2019	Christophe Battarel	<christophe.battarel@altairis.fr>
 * Copyright (C) 2012       Cédric Salvador     <csalvador@gpcsolutions.fr>
 * Copyright (C) 2012-2014  Raphaël Doursenaud  <rdoursenaud@gpcsolutions.fr>
 * Copyright (C) 2013		Florian Henry		<florian.henry@open-concept.pro>
 * Copyright (C) 2017		Juanjo Menent		<jmenent@2byte.es>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Need to have following variables defined:
 * $object (invoice, order, ...)
 * $conf
 * $langs
 * $dateSelector
 * $forceall (0 by default, 1 for supplier invoices/orders)
 * $element     (used to test $user->rights->$element->creer)
 * $permtoedit  (used to replace test $user->rights->$element->creer)
 * $senderissupplier (0 by default, 1 for supplier invoices/orders)
 * $inputalsopricewithtax (0 by default, 1 to also show column with unit price including tax)
 * $usemargins (0 to disable all margins columns, 1 to show according to margin setup)
 * $object_rights->creer initialized from = $object->getRights()
 * $disableedit, $disablemove, $disableremove
 *
 * $type, $text, $description, $line
 */

// Protection to avoid direct call of template
if (empty($object) || ! is_object($object))
{
	print "Error, template page can't be called as URL";
	exit;
}

if (empty($conf->global->DOLITOOLS_USE_ALTATPL)) return;

if ( ! in_array($object->element, array('propal','supplier_proposal','facture','facturerec','invoice','commande','order','order_supplier','invoice_supplier')) ) return;

global $forceall, $senderissupplier, $inputalsopricewithtax, $outputalsopricetotalwithtax;

$usemargins=0;
if (! empty($conf->margin->enabled) && ! empty($object->element) && in_array($object->element, array('facture','facturerec','propal','commande'))) $usemargins=1;
// recalcul marge (en particulier pour location)
if (! empty($line->array_options['options_rental_line']))
{
	if ($line->total_ht < 0)
		$marge = -1 * (abs($line->total_ht) - (abs($line->pa_ht) * $line->qty));
	else
		$marge = $line->total_ht - ($line->pa_ht * $line->qty);

	// calcul taux marge
	if ($line->pa_ht != 0)
		$line->marge_tx = (100 * $marge) / ($line->pa_ht * $line->qty);
	// calcul taux marque
	if ($line->total_ht != 0)
		$line->marque_tx = (100 * $marge) / $line->total_ht;
}

$showmargins = $usemargins; // && (empty($conf->rental->enabled) || empty($object->array_options['options_rental_doc']));

if (empty($dateSelector)) $dateSelector=0;
if (empty($forceall)) $forceall=0;
if (empty($senderissupplier)) $senderissupplier=0;
if (empty($inputalsopricewithtax)) $inputalsopricewithtax=0;
if (empty($outputalsopricetotalwithtax)) $outputalsopricetotalwithtax=0;

// add html5 elements
$domData  = ' data-element="'.$line->element.'"';
$domData .= ' data-id="'.$line->id.'"';
$domData .= ' data-qty="'.$line->qty.'"';
$domData .= ' data-product_type="'.$line->product_type.'"';

// get stock infos
if (! empty($conf->global->ALTATPL_STOCK_ON_LINES) && $line->fk_product > 0 && empty($senderissupplier))
{
	include_once __DIR__ . '/../../lib/availablestock.lib.php';
	$stock_available = get_stock_for_line($line->fk_product, $line->array_options);
}

?>
<?php $coldisplay=0; ?>
<!-- BEGIN PHP TEMPLATE objectline_view.tpl.php -->
<tr  id="row-<?php echo $line->id?>" class="drag drop oddeven" <?php echo $domData; ?> >

	<?php
	if ($object->brouillon && ! empty($conf->global->DOLITOOLS_USE_DELETELINES) && $action != 'editline')
	{
		print '<td align="center"><input name="sel_'.$line->id.'" type="checkbox"';
		if (GETPOST("sel_".$line->id)) print ' checked="checked"';
		$coldisplay++;
		print ' /></td>';
	}
	?>

	<?php if (! empty($conf->global->MAIN_VIEW_LINE_NUMBER)) { ?>
	<td class="linecolnum center"><?php $coldisplay++; ?><?php echo $line->rang; ?></td>
	<?php } ?>
	<td class="linecoldescription minwidth300imp"><?php $coldisplay++; ?><div id="line_<?php echo $line->id; ?>"></div>
	<?php
	if (($line->info_bits & 2) == 2) {
	?>
		<a href="<?php echo DOL_URL_ROOT.'/comm/remx.php?id='.$this->socid; ?>">
		<?php
		$txt='';
		print img_object($langs->trans("ShowReduc"), 'reduc').' ';
		if ($line->description == '(DEPOSIT)') $txt=$langs->trans("Deposit");
		elseif ($line->description == '(EXCESS RECEIVED)') $txt=$langs->trans("ExcessReceived");
		elseif ($line->description == '(EXCESS PAID)') $txt=$langs->trans("ExcessPaid");
		//else $txt=$langs->trans("Discount");
		print $txt;
		?>
		</a>
		<?php
		if ($line->description)
		{
			if ($line->description == '(CREDIT_NOTE)' && $line->fk_remise_except > 0)
			{
				$discount=new DiscountAbsolute($this->db);
				$discount->fetch($line->fk_remise_except);
				echo ($txt?' - ':'').$langs->transnoentities("DiscountFromCreditNote", $discount->getNomUrl(0));
			}
			elseif ($line->description == '(DEPOSIT)' && $line->fk_remise_except > 0)
			{
				$discount=new DiscountAbsolute($this->db);
				$discount->fetch($line->fk_remise_except);
				echo ($txt?' - ':'').$langs->transnoentities("DiscountFromDeposit", $discount->getNomUrl(0));
				// Add date of deposit
				if (! empty($conf->global->INVOICE_ADD_DEPOSIT_DATE))
				    echo ' ('.dol_print_date($discount->datec).')';
			}
			elseif ($line->description == '(EXCESS RECEIVED)' && $objp->fk_remise_except > 0)
			{
				$discount=new DiscountAbsolute($this->db);
				$discount->fetch($line->fk_remise_except);
				echo ($txt?' - ':'').$langs->transnoentities("DiscountFromExcessReceived", $discount->getNomUrl(0));
			}
			elseif ($line->description == '(EXCESS PAID)' && $objp->fk_remise_except > 0)
			{
				$discount=new DiscountAbsolute($this->db);
				$discount->fetch($line->fk_remise_except);
				echo ($txt?' - ':'').$langs->transnoentities("DiscountFromExcessPaid", $discount->getNomUrl(0));
			}
			else
			{
				echo ($txt?' - ':'').dol_htmlentitiesbr($line->description);
			}
		}
	}
	else
	{
		$format = $conf->global->MAIN_USE_HOURMIN_IN_DATE_RANGE?'dayhour':'day';

	    if ($line->fk_product > 0)
		{
			//Commented by Christophe Battarelif ( ! empty($conf->occasions->enabled))
			//Commented by Christophe Battarel{
				//Commented by Christophe Battarel$langs->load('occasions@occasions');
				//Commented by Christophe Battarel$text .= ' - <span style="color: red; font-weight: bold;">'.$langs->trans('ConditionUsed').'</span>';
			//Commented by Christophe Battarel}
			echo $form->textwithtooltip($text, $description, 3, '', '', $i, 0, (!empty($line->fk_parent_line)?img_picto('', 'rightarrow'):''));
		}
		else
		{
			if ($type==1) $text = img_object($langs->trans('Service'), 'service');
			else $text = img_object($langs->trans('Product'), 'product');

			if (! empty($line->label)) {
				$text.= ' <strong>'.$line->label.'</strong>';
				echo $form->textwithtooltip($text, dol_htmlentitiesbr($line->description), 3, '', '', $i, 0, (!empty($line->fk_parent_line)?img_picto('', 'rightarrow'):''));
			} else {
				if (! empty($line->fk_parent_line)) echo img_picto('', 'rightarrow');
				echo $text.' '.dol_htmlentitiesbr($line->description);
			}
		}

		// Show date range
		if ($line->element == 'facturedetrec') {
			if ($line->date_start_fill || $line->date_end_fill) echo '<br><div class="clearboth nowraponall">';
			if ($line->date_start_fill) echo $langs->trans('AutoFillDateFromShort').': '.yn($line->date_start_fill);
			if ($line->date_start_fill && $line->date_end_fill) echo ' - ';
			if ($line->date_end_fill) echo $langs->trans('AutoFillDateToShort').': '.yn($line->date_end_fill);
			if ($line->date_start_fill || $line->date_end_fill) echo '</div>';
		}
		else {
			if ($line->date_start || $line->date_end) echo '<br><div class="clearboth nowraponall">'.get_date_range($line->date_start, $line->date_end, $format).'</div>';
			//echo get_date_range($line->date_start, $line->date_end, $format);
		}

		// Add description in form
		if ($line->fk_product > 0 && ! empty($conf->global->PRODUIT_DESC_IN_FORM))
		{
			print (! empty($line->description) && $line->description!=$line->product_label)?'<br>'.dol_htmlentitiesbr($line->description):'';
		}
	}

	if (! empty($conf->accounting->enabled) && $line->fk_accounting_account > 0)
	{
		$accountingaccount=new AccountingAccount($this->db);
		$accountingaccount->fetch($line->fk_accounting_account);
		echo '<div class="clearboth"></div><br><span class="opacitymedium">' . $langs->trans('AccountingAffectation') . ' : </span>' . $accountingaccount->getNomUrl(0, 1, 1);
	}

	?>
	</td>
	<?php
	if  (empty($conf->global->ALTATPL_HIDE_REF_FOURN) && ($object->element == 'supplier_proposal' || $object->element == 'order_supplier' || $object->element == 'invoice_supplier'))	{
	?>
		<td class="linecolrefsupplier nowrap"><?php
		echo ($line->ref_fourn?$line->ref_fourn:$line->ref_supplier);
		?></td>
	<?php
	}
	?>

	<td class="linecolqty nowrap right"><?php $coldisplay++; ?>
    <?php
    if ((($line->info_bits & 2) != 2) && $line->special_code != 3) {
		// I comment this because it shows info even when not required
		// for example always visible on invoice but must be visible only if stock module on and stock decrease option is on invoice validation and status is not validated
		// must also not be output for most entities (proposal, intervention, ...)
		//if($line->qty > $line->stock) print img_picto($langs->trans("StockTooLow"),"warning", 'style="vertical-align: bottom;"')." ";
		echo price($line->qty, 0, '', 0, 0);  // Yes, it is a quantity, not a price, but we just want the formating role of function price
    } else echo '&nbsp;';
    ?>
	</td>

	<?php
	if($conf->global->PRODUCT_USE_UNITS)
	{
		print '<td class="linecoluseunit nowrap left">';
		$label = $line->getLabelOfUnit('short');
		if ($label !== '') {
			print $langs->trans($label);
		}
		print '</td>';
	}

	// Stock infos
	if (! empty($conf->stock->enabled) && ! empty($conf->global->ALTATPL_STOCK_ON_LINES) && empty($senderissupplier))
	{
		print '<td class="nowrap"><div class="dispo">';

		if ($line->fk_product > 0)
		{
			if (empty($line->array_options['options_rental_line']))
			{
				$stockLink = dol_buildpath('/product/stock/product.php',1).'?id='.$line->fk_product;
				print '<div class="stock_reel disponibilite"><a href="'.$stockLink.'" target="_blank" title="'.$langs->trans(!empty($conf->global->USE_AVAILABLE_STOCK)?"AvailableStockDetails":"RealStock").': '.$stock_available.'">'.$stock_available.'</a></div>';
			}
			else
			{
				print '<a class="show_dispo" href="#" onclick="return showProductRentalInfos(\'row-'.$line->id.'\','.$line->fk_product.');">'.$langs->trans("Show").'</a>';
			}
		}
		print '</div></td>';
		$coldisplay++;
	}

	// for v11
	if (empty($extrafieldsline) && ! empty($extrafields)) $extrafieldsline = $extrafields;
	// end v11

	// hook to complete line with other cells
	$parameters = array('line'=>$line,'var'=>$var,'num'=>$num,'i'=>$i,'dateSelector'=>$dateSelector,'seller'=>$seller,'buyer'=>$buyer,'selected'=>$selected, 'extrafieldsline'=>$extrafieldsline);
	$reshook = $hookmanager->executeHooks('altatpl_completeObjectLine', $parameters, $this, $action);    // Note that $action and $object may have been modified by some hooks
	if (! empty($reshook)) { print '</tr>'; exit; }

	//Line extrafield
	if (!empty($extrafieldsline) && ! empty($conf->global->ALTATPL_EXTRAFIELDS_IN_COLUMNS))
	{
		include_once __DIR__ . '/../../lib/altatpl.lib.php';
		$coldisplay += altatpl_showOptionalsValues($line, $extrafieldsline, 'view', $line->array_options['options_rental_line']);
	}


	?>
	<td class="linecoluht nowrap right"><?php $coldisplay++; ?><?php echo price($line->subprice); ?></td>

	<?php if (!empty($conf->multicurrency->enabled) && $this->multicurrency_code != $conf->currency) { ?>
	<td class="linecoluht_currency nowrap right"><?php $coldisplay++; ?><?php echo price($line->multicurrency_subprice); ?></td>
	<?php } ?>

	<td class="linecolvat nowrap right"><?php $coldisplay++; ?><?php
	$positiverates='';
	if (price2num($line->tva_tx))          $positiverates.=($positiverates?'/':'').price2num($line->tva_tx);
	if (price2num($line->total_localtax1)) $positiverates.=($positiverates?'/':'').price2num($line->localtax1_tx);
	if (price2num($line->total_localtax2)) $positiverates.=($positiverates?'/':'').price2num($line->localtax2_tx);
	if (empty($positiverates)) $positiverates='0';
	echo vatrate($positiverates.($line->vat_src_code?' ('.$line->vat_src_code.')':''), '%', $line->info_bits);
	//echo vatrate($line->tva_tx.($line->vat_src_code?(' ('.$line->vat_src_code.')'):''), '%', $line->info_bits);
	?></td>

	<?php if ( ! empty($conf->global->ALTATPL_SHOW_TTCPRICE)) { ?>
	<td class="linecoluttc nowrap right"><?php $coldisplay++; ?><?php echo (isset($line->pu_ttc)?price($line->pu_ttc):price($line->subprice)); ?></td>
	<?php } ?>

	<?php if (!empty($line->remise_percent) && $line->special_code != 3) { ?>
	<td class="linecoldiscount right"><?php
		$coldisplay++;
		include_once DOL_DOCUMENT_ROOT.'/core/lib/functions2.lib.php';
		echo dol_print_reduction($line->remise_percent, $langs);
	?></td>
	<?php } else { ?>
	<td class="linecoldiscount"><?php $coldisplay++; ?>&nbsp;</td>
	<?php }
	// discounted price
	$rounding = min($conf->global->MAIN_MAX_DECIMALS_UNIT, $conf->global->MAIN_MAX_DECIMALS_TOT);

	if (!empty($conf->global->ALTATPL_SHOW_DISCOUNTEDPRICE))
	{
	?>
		<td class="nowrap right"><?php $coldisplay++; ?><?php echo price($line->subprice * (1 - $line->remise_percent / 100)  + ($line->array_options['options_rental_warranty_price']?($line->array_options['options_rental_warranty_price'] * $line->remise_percent / 100):0), null, null, null, null, $rounding); ?></td>
	<?php
	}

	// Fields for situation invoices
	if ($this->situation_cycle_ref)
	{
	    include_once DOL_DOCUMENT_ROOT.'/core/lib/price.lib.php';
		$coldisplay++;
		print '<td class="linecolcycleref nowrap right">' . $line->situation_percent . '%</td>';
		$coldisplay++;
		$locataxes_array = getLocalTaxesFromRate($line->tva.($line->vat_src_code ? ' ('.$line->vat_src_code.')' : ''), 0, ($senderissupplier?$mysoc:$object->thirdparty), ($senderissupplier?$object->thirdparty:$mysoc));
		$tmp = calcul_price_total($line->qty, $line->pu, $line->remise_percent, $line->txtva, -1, -1, 0, 'HT', $line->info_bits, $line->type, ($senderissupplier?$object->thirdparty:$mysoc), $locataxes_array, 100, $object->multicurrency_tx, $line->multicurrency_subprice);
		print '<td align="right" class="linecolcycleref2 nowrap">' . price($tmp[0]) . '</td>';
	}

  	if ($showmargins && ! empty($conf->margin->enabled) && empty($user->societe_id))
  	{
  		if (!empty($user->rights->margins->creer)) { ?>
	  	  <td class="linecolmargin1 nowrap margininfos right"><?php $coldisplay++; ?><?php echo price($line->pa_ht); ?></td>
	  	<?php } ?>
	  	<?php if (! empty($conf->global->DISPLAY_MARGIN_RATES) && $user->rights->margins->liretous) { ?>
	  	  <td class="linecolmargin2 nowrap margininfos right"><?php $coldisplay++; ?><?php echo (($line->pa_ht == 0)?'n/a':price($line->marge_tx, null, null, null, null, $rounding).'%'); ?></td>
	  	<?php }
	    if (! empty($conf->global->DISPLAY_MARK_RATES) && $user->rights->margins->liretous) {?>
	  	  <td class="linecolmargin2 nowrap margininfos right"><?php $coldisplay++; ?><?php echo price($line->marque_tx, null, null, null, null, $rounding).'%'; ?></td>
	    <?php }
	}
	?>

	<?php if ($line->special_code == 3)	{ ?>
		<td class="linecoloption nowrap right"><?php $coldisplay++; ?><?php echo $langs->trans('Option'); ?></td>
	<?php } else { ?>
		<td class="linecolht nowrap right"><?php
		  $coldisplay++;
		  if (empty($conf->global->MAIN_OPTIMIZEFORTEXTBROWSER))
		  {
    		  print '<span class="classfortooltip" title="';
    		  print $langs->transcountry("TotalHT", $mysoc->country_code).'='.price($line->total_ht);
    		  print '<br>'.$langs->transcountry("TotalVAT", ($senderissupplier?$object->thirdparty->country_code:$mysoc->country_code)).'='.price($line->total_tva);
    		  if (price2num($line->total_localtax1)) print '<br>'.$langs->transcountry("TotalLT1", ($senderissupplier?$object->thirdparty->country_code:$mysoc->country_code)).'='.price($line->total_localtax1);
    		  if (price2num($line->total_localtax2)) print '<br>'.$langs->transcountry("TotalLT2", ($senderissupplier?$object->thirdparty->country_code:$mysoc->country_code)).'='.price($line->total_localtax2);
    		  print '<br>'.$langs->transcountry("TotalTTC", $mysoc->country_code).'='.price($line->total_ttc);
    		  print '">';
		  }
		  print price($line->total_ht);
		  if (empty($conf->global->MAIN_OPTIMIZEFORTEXTBROWSER))
		  {
		      print '</span>';
		  }
		  ?>
		</td>
		<?php if (!empty($conf->multicurrency->enabled) && $this->multicurrency_code != $conf->currency) { ?>
			<td class="linecolutotalht_currency nowrap right"><?php $coldisplay++; ?><?php echo price($line->multicurrency_total_ht); ?></td>
		<?php } ?>
	<?php } ?>
    <?php if ($outputalsopricetotalwithtax) { ?>
        <td class="linecolht nowrap right"><?php $coldisplay++; ?><?php echo price($line->total_ttc); ?></td>
    <?php } ?>


	<?php
	if ($this->statut == 0  && ($object_rights->creer) && $action != 'selectlines' ) { ?>
		<td class="linecoledit center"><?php $coldisplay++; ?>
			<?php if (($line->info_bits & 2) == 2 || ! empty($disableedit)) { ?>
			<?php } else {
				if ($i > 0)
				{ ?>
					<a href="<?php echo $_SERVER["PHP_SELF"].'?id='.$this->id.'&amp;action=editline&amp;lineid='.$line->id.'#editline'; ?>">
			<?php
				}
				else
				{ ?>
					<a href="<?php echo $_SERVER["PHP_SELF"].'?id='.$this->id.'&amp;action=editline&amp;lineid='.$line->id.'#tablelines' ?>">
			<?php
				}
				echo img_edit(); ?>
			</a>
			<?php } ?>
		</td>

		<td class="linecoldelete center"><?php $coldisplay++; ?>
			<?php
			if (($line->fk_prev_id == null ) && empty($disableremove)) { //La suppression n'est autorisée que si il n'y a pas de ligne dans une précédente situation
				print '<a href="' . $_SERVER["PHP_SELF"] . '?id=' . $this->id . '&amp;action=ask_deleteline&amp;lineid=' . $line->id . '">';
				print img_delete();
				print '</a>';
			}
			?>
		</td>

		<?php
		if ($num > 1 && $conf->browser->layout != 'phone' && ($this->situation_counter == 1 || !$this->situation_cycle_ref) && empty($disablemove)) { ?>
		<td class="linecolmove tdlineupdown center"><?php $coldisplay++; ?>
			<?php if ($i > 0) { ?>
			<a class="lineupdown" href="<?php echo $_SERVER["PHP_SELF"].'?id='.$this->id.'&amp;action=up&amp;rowid='.$line->id; ?>">
			<?php echo img_up('default', 0, 'imgupforline'); ?>
			</a>
			<?php } ?>
			<?php if ($i < $num-1) { ?>
			<a class="lineupdown" href="<?php echo $_SERVER["PHP_SELF"].'?id='.$this->id.'&amp;action=down&amp;rowid='.$line->id; ?>">
			<?php echo img_down('default', 0, 'imgdownforline'); ?>
			</a>
			<?php } ?>
		</td>
	    <?php } else { ?>
	    <td <?php echo (($conf->browser->layout != 'phone' && empty($disablemove)) ?' class="linecolmove tdlineupdown center"':' class="linecolmove center"'); ?>><?php $coldisplay++; ?></td>
		<?php } ?>
	<?php
    } else {
	?>
		<td colspan="3"><?php $coldisplay=$coldisplay+3; ?></td>
	<?php
    }

    if($action == 'selectlines'){ ?>
		<td class="linecolcheck center"><input type="checkbox" class="linecheckbox" name="line_checkbox[<?php echo $i+1; ?>]" value="<?php echo $line->id; ?>" ></td>
	<?php } ?>

</tr>

<?php
//Line extrafield
if (!empty($extrafieldsline) && empty($conf->global->ALTATPL_EXTRAFIELDS_IN_COLUMNS))
{
	print $line->showOptionals($extrafieldsline, 'view', array('style'=>'class="drag drop oddeven"','colspan'=>$coldisplay), '', '', 0);
}

// composants packs
if ( ! empty($conf->global->PRODUIT_SOUSPRODUITS) && ! empty($line->fk_product) )
{
	require_once DOL_DOCUMENT_ROOT . '/product/class/product.class.php';
	$productstatic = new Product($this->db);
	$components = $productstatic->getChildsArbo($line->fk_product);
	if (count($components) > 0)
	{
		foreach($components as $component)
		{
			print '<tr class="oddeven" id="row-'.$line->id.'_'.$component[0].'">';
			if ($object->brouillon && ! empty($conf->global->DOLITOOLS_USE_DELETELINES) && $action != 'editline') print '<td></td>';
			if (! empty($conf->global->MAIN_VIEW_LINE_NUMBER)) print '<td></td>';
			print '<td>';
			print '---> '.$component[1].' '.$component[3];
			print '</td>';
			// qté totale
			print '<td class="right">'.($component[1] * $line->qty).'</td>';
			// Stock infos
			if (! empty($conf->stock->enabled) && ! empty($conf->global->ALTATPL_STOCK_ON_LINES) && empty($senderissupplier))
			{
				print '<td><div class="dispo">';

				if ($component[0] > 0)
				{
					if (empty($line->array_options['options_rental_line']))
					{
						// get stock infos
						if (! empty($conf->global->ALTATPL_STOCK_ON_LINES) && empty($senderissupplier))
						{
							include_once __DIR__ . '/../../lib/availablestock.lib.php';
							$stock_available = get_stock_for_line($component[0], $line->array_options);
						}
						$stockLink = dol_buildpath('/product/stock/product.php',1).'?id='.$component[0];
						print '<div class="stock_reel disponibilite"><a href="'.$stockLink.'" target="_blank" title="'.$langs->trans(!empty($conf->global->USE_AVAILABLE_STOCK)?"AvailableStockDetails":"RealStock").': '.$stock_available.'">'.$stock_available.'</a></div>';
					}
					else
					{
						print '<a class="show_dispo" href="#" onclick="return showProductRentalInfos(\'row-'.$line->id.'_'.$component[0].'\','.$component[0].');">'.$langs->trans("Show").'</a>';
					}
				}
				print '</div></td>';
				$coldisplay++;
			}
			print '<td colspan="100"></td>';
			print '</tr>';
		}
	}
}
?>
<!-- END PHP TEMPLATE objectline_view.tpl.php -->
