<?php
/* Copyright (C) 2020		Christophe Battarel	<christophe.battarel@altairis.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Need to have following variables defined:
 * $object (invoice, order, ...)
 * $conf
 * $langs
 * $seller, $buyer
 * $dateSelector
 * $forceall (0 by default, 1 for supplier invoices/orders)
 * $senderissupplier (0 by default, 1 for supplier invoices/orders)
 * $inputalsopricewithtax (0 by default, 1 to also show column with unit price including tax)
 */

?>

<script type="text/javascript">
	function toggle_line(e)
	{
		var del = $(e).hasClass("delete");
		var tr = $(e).parents("tr:first");
		$("span.delete_line, div.restore_line", tr).toggle();
		$("input:visible, select, textarea", tr).prop("disabled", del); // dont disable hidden fields (especially lineid)
		$(tr).toggleClass("deleted", del);
		$(e).toggleClass("delete");
		$("form#draftedit").data("changed",true);
		$("a.draftchanged").show();
		return false;
	}

	function addline(e)
	{
		$("div.tabsAction").hide();

		var tr = $(e).parents("tr:first");

		var isrental = $(tr).parents("div:first").attr("id") == "rentalLines" || $(tr).parents("div:first").attr("id") == "mixLines";
		var nextTr = $(tr).next('tr:first');
		var trPivot = tr;
		if (nextTr.hasClass('treditedlinefordate')) trPivot = nextTr;
		if ($(trPivot).hasClass("liste_titre")) $(trPivot).hide();

		// rental checkbox has same value of previous line if any
		if ($("input[name^=options_rental_line]", trPivot).length > 0) isrental = $("input[name^=options_rental_line]", trPivot).prop("checked");

		$("tr.draftcreate input[id!=options_rental_line][id!=options_rental_duration][class!=button], tr.draftcreate select, tr.draftcreate textarea").val('');
		$("tr.draftcreate input[id=qty]").val('1');
		$("tr.draftcreate div.dispo").html('');
		$("tr.draftcreate").toggleClass("rental", isrental).toggleClass("sale", ! isrental);
		$("tr.draftcreate input, tr.draftcreate textarea").prop( "disabled", false );
		<?php
		if (! empty($conf->global->MAIN_VIEW_LINE_NUMBER)) {
		?>
			var rank = $('input[name^=rank]', tr).val();
			if (rank >= 0) rank++;
			else rank = 1;
			$('tr.draftcreate #rank').val(rank).prop("disabled", true);
		<?php
		}
		?>

		// we need to replace ckeditor when moving the row
		var use_ck;
		var ck_options = {};
		if(typeof CKEDITOR == "object" && typeof CKEDITOR.instances != "undefined" && typeof CKEDITOR.instances['dp_desc'] != 'undefined') {
			ck_options = CKEDITOR.instances['dp_desc'].config;
			CKEDITOR.instances['dp_desc'].updateElement();
			CKEDITOR.instances['dp_desc'].destroy();
			use_ck = true;
		}

		if ( $(trPivot).hasClass("liste_titre") )
		{
			// first line
			var tbody = $(trPivot).parents("table:first").find("tbody:first");
			$("tr.draftcreate").prependTo(tbody).show();
		}
		else $("tr.draftcreate").insertAfter(trPivot).show();

		// we need to replace ckeditor when moving the row
		if (use_ck) CKEDITOR.replace("dp_desc", ck_options);

		$("tr.draftcreate #options_rental_line").prop("checked", isrental).change();
	}

	function prepare_dnd(table)
	{
		$(".imgupforline").hide();
		$(".imgdownforline").hide();
		$(".lineupdown").removeAttr('href');
		$(".tdlineupdown").css("background-image",'url(<?php echo DOL_URL_ROOT.'/theme/'.$conf->theme.'/img/grip.png'; ?>)');
		$(".tdlineupdown").css("background-repeat","no-repeat");
		$(".tdlineupdown").css("background-position","center center");

		// we need to replace ckeditor when moving the row
		var use_ck;
		var ck_options = {};
		var ckid;

		$(table).tableDnD({
			onDragStart: function(tbl, elem) {
				var tr = $(elem).parents("tr:first");
				if ($(tr).hasClass("newline")) ckid = 'dp_desc_' + $(tr).attr("id");
				else ckid = 'product_desc_' + $(tr).attr("id").replace("row-", "");
				if(typeof CKEDITOR == "object" && typeof CKEDITOR.instances != "undefined" && typeof CKEDITOR.instances[ckid] != 'undefined') {
					ck_options = CKEDITOR.instances[ckid].config;
					CKEDITOR.instances[ckid].updateElement();
					CKEDITOR.instances[ckid].destroy();
					use_ck = true;
				}
			},
			onDrop: function(tbl, row) {
				// we need to replace ckeditor when moving the row
				if (use_ck) CKEDITOR.replace(ckid, ck_options);

				reorder_lines($("tbody:first", table));
			},
			onDragClass: "dragClass",
			dragHandle: "td.tdlineupdown"
		});
		$(".tdlineupdown").hover( function() { $(this).addClass('showDragHandle'); },
			function() { $(this).removeClass('showDragHandle'); }
		);
	}

	$(document).ready(function()
	{
		$("table.tablelines").each(function() { prepare_dnd(this); });

		$("tr.draftcreate input").prop( "disabled", true );

		$("table").on("blur", "[name^=div_product_label]", function(event) {
			var tr = $(this).parents("tr:first");
			$("input[name^=product_label]", tr).val($(this).html()).change();
		});
	});

<?php
if (! empty($conf->stock->enabled) && empty($senderissupplier))
{
?>
	// [name] is the name of the event "click", "mouseover", ..
	// same as you\'d pass it to bind()
	// [fn] is the handler function
	$.fn.bindFirst = function(name, fn) {
		// bind as you normally would
		// don\'t want to miss out on any jQuery magic
		this.on(name, fn);

		// Thanks to a comment by @Martin, adding support for
		// namespaced events too.
		this.each(function() {
			var handlers = $._data(this, "events")[name.split(".")[0]];
			// take out the handler we just inserted from the end
			var handler = handlers.pop();
			// move it at the beginning
			handlers.splice(0, 0, handler);
		});
	};

	function checkQtyStockEdit(e)
	{
		var tr = $(this).parents("tr:first");

		if ( ! $("input[name^=options_rental_line]",tr).prop("checked")
		&& ($(e.relatedTarget).parents("tr:first").is(tr) || e.which == 1)
		&& ( typeof $(e.relatedTarget).attr("id") == "undefined" || $(e.relatedTarget).attr("id") != 'cancellinebutton')
		&& ( typeof $(e.relatedTarget).attr("name") == "undefined" || $(e.relatedTarget).attr("name") != 'search_idprod')
		&& ( typeof $(e.relatedTarget).attr("name") == "undefined" || ! $(e.relatedTarget).attr("name").startsWith('options_rental_line'))
		&& ( typeof $(e.relatedTarget).attr("name") == "undefined" || ! $(e.relatedTarget).attr("name").startsWith('options_used_line'))
		&& ($("select[name^=options_used_line]",tr).val() == "1" || $("input[name^=onpurchase]",tr).val() == "0")
		&& $("input[name^=qty]",tr).val() * 1 > 0
		&& $("input[name^=qty]",tr).val() * 1 > $("input[name^=stock_available]",tr).val() * 1
<?php
if ( empty($conf->global->STOCK_SUPPORTS_SERVICES) ) {
?>
		&& $("input[name^=type]",tr).val() == 0
<?php
}
?>
		)
		{
			e.stopImmediatePropagation();

			$("input[name^=qty]",tr).focus().select();

			alert("<?php echo $langs->trans("QtyNotInStock"); ?>");

			return false;
		}
	}

	$(document).ready(function()
	{
		$("table input[name^=qty]").bindFirst("blur", checkQtyStockEdit);
		$("input#addline").bindFirst("click", checkQtyStockEdit);
	});
<?php
}
if (! empty($showmargins) && $user->rights->margins->creer)
{
?>

	/* Some js test when we click on button "Add" */
	$(document).ready(function() {
		<?php
		if (! empty($conf->global->DISPLAY_MARGIN_RATES)) { ?>
			$("input[name^='np_marginRate']").change(function(e) {
				var tr = $(this).parents("tr:first");
				return checkFreeLine(e, "np_marginRate", tr);
			});
		<?php
		}
		if (! empty($conf->global->DISPLAY_MARK_RATES)) { ?>
			$("input[name^='np_markRate']").change(function(e) {
				var tr = $(this).parents("tr:first");
				return checkFreeLine(e, "np_markRate", tr);
			});
		<?php
		}
		?>
	});

	/* TODO This does not work for number with thousand separator that is , */
	function checkFreeLine(e, npRate, tr)
	{
		var buying_price = $("input[name^='buying_price']", tr);
		var remise = $("input[name^='remise_percent']", tr);

		var rate = $("input[name='"+npRate+"']", tr);
		if (rate.val() == '')
			return true;

		var ratejs = price2numjs(rate.val());
		if (! $.isNumeric(ratejs))
		{
			alert('<?php echo dol_escape_js($langs->trans("rateMustBeNumeric")); ?>');
			e.stopPropagation();
			setTimeout(function () { rate.focus() }, 50);
			return false;
		}
		if (npRate == "np_markRate" && rate.val() >= 100)
		{
			alert('<?php echo dol_escape_js($langs->trans("markRateShouldBeLesserThan100")); ?>');
			e.stopPropagation();
			setTimeout(function () { rate.focus() }, 50);
			return false;
		}

		var price = 0;
		remisejs=price2numjs(remise.val());

		if (remisejs != 100)	// If a discount not 100 or no discount
		{
			if (remisejs == '') remisejs=0;

			bpjs=price2numjs(buying_price.val());
			ratejs=price2numjs(rate.val());

			if (npRate == "np_marginRate")
				price = ((bpjs * (1 + ratejs / 100)) / (1 - remisejs / 100));
			else if (npRate == "np_markRate")
				price = ((bpjs / (1 - ratejs / 100)) / (1 - remisejs / 100));
		}
		$("input[name^='price_ht']", tr).val(price).change();	// TODO Must use a function like php price to have here a formated value

		return true;
	}

<?php
}
?>
$(document).ready(function()
{
	// delegation events binding will cause dynamically created elements to get the binding !
	$("table").on("change", "input[name^=price_ht]", function(event) {
		var tr = $(this).parents("tr:first");
		if ($("input[name^=options_rental_line]", tr).prop("checked")) return;
			var price_ht = price2numjs($(this).val());
			var tva_tx = price2numjs($("select[name^=tva_tx]", tr).val());
			$("input[name^=price_ttc]", tr).val(price_ht * (1 + tva_tx / 100));
			var remise_percent = price2numjs($("input[name^=remise_percent]", tr).val());
			var discounted = price_ht * (1 - remise_percent / 100);
			$("input[name^=discounted_price]", tr).val(discounted);
			var qty = $("input[name^=qty]", tr).val();
			$("td.linecolht", tr).text(discounted * qty);
			$("input[name^=multicurrency_subprice]", tr).val('');
	});

	$("table").on("change", "input[name^=discounted_price]", function(event) {
		var tr = $(this).parents("tr:first");
		if ($("input[name^=options_rental_line]", tr).prop("checked")) return;
			var pxrem = price2numjs($(this).val());
			var price_ht = price2numjs($("input[name^=price_ht]", tr).val());
			if (price_ht != 0) $("input[name^=remise_percent]", tr).val(((price_ht - pxrem) / price_ht) * 100);
			$("input[name^=multicurrency_subprice]", tr).val('');
	});

	$("table").on("change", "input[name^=remise_percent]", function(event) {
		var tr = $(this).parents("tr:first");
		if ($("input[name^=options_rental_line]", tr).prop("checked")) return;
			var remise_percent = price2numjs($(this).val());
			var price_ht = price2numjs($("input[name^=price_ht]", tr).val());
			$("input[name^=discounted_price]", tr).val(price_ht * (1 - remise_percent / 100));
			$("input[name^=multicurrency_subprice]", tr).val('');
	});

	$("table").on("change", "[name^=tva_tx]", function(event) {
		var tr = $(this).parents("tr:first");
			var price_ht = price2numjs($("input[name^=price_ht]", tr).val());
			var tva_tx = price2numjs($(this).val());
			$("input[name^=price_ttc]", tr).val(price_ht * (1 + tva_tx / 100));
	});

	$("table").on("change", "input[name^=price_ttc]", function(event) {
		var tr = $(this).parents("tr:first");
		// console.log(event.which);		// discard event tag and arrows
			var price_ttc = price2numjs($(this).val());
			var tva_tx = price2numjs($("[name^=tva_tx]", tr).val());
			if (parseFloat(tva_tx) == 0) $("input[name^=price_ht]", tr).val(price_ttc).change();
			else $("input[name^=price_ht]", tr).val(price_ttc / (1 + tva_tx / 100)).change();
			$("input[name^=multicurrency_subprice]", tr).val('');
	});

	$("table").on("change", "input[name^=multicurrency_subprice]", function(event) {
		var tr = $(this).parents("tr:first");
		// console.log(event.which);		// discard event tag and arrows
			$("input[name^=price_ht]", tr).val('');
			$("input[name^=price_ttc]", tr).val('');
			$("input[name^=discounted_price]", tr).val('');
	});

    <?php
    if (! empty($conf->margin->enabled))
    {
    ?>
		/* Add rule to clear margin when we change some data, so when we change sell or buy price, margin will be recalculated after submitting form */
		$("table").on("click", "[name^=tva_tx]", function(event) {
			var tr = $(this).parents("tr:first");
			$("input[name^='np_marginRate']", tr).val('');
			$("input[name^='np_markRate']", tr).val('');
		});
		$("table").on("keyup", "[name^=tva_tx]", function(event) {
			var tr = $(this).parents("tr:first");
			$("input[name^='np_marginRate']", tr).val('');
			$("input[name^='np_markRate']", tr).val('');
		});
		$("table").on("keyup", "[name^=price_ht]", function(event) {
			var tr = $(this).parents("tr:first");
			$("input[name^='np_marginRate']", tr).val('');
			$("input[name^='np_markRate']", tr).val('');
		});
		$("table").on("keyup", "[name^=qty]", function(event) {
			var tr = $(this).parents("tr:first");
			$("input[name^='np_marginRate']", tr).val('');
			$("input[name^='np_markRate']", tr).val('');
		});
		$("table").on("keyup", "[name^=remise_percent]", function(event) {
			var tr = $(this).parents("tr:first");
			$("input[name^='np_marginRate']", tr).val('');
			$("input[name^='np_markRate']", tr).val('');
		});
		$("table").on("keyup", "[name^=buying_price]", function(event) {
			var tr = $(this).parents("tr:first");
			$("input[name^='np_marginRate']", tr).val('');
			$("input[name^='np_markRate']", tr).val('');
		});

    <?php
    }
    ?>
});

</script>
