<?php
/* Copyright (C) 2010-2012	Regis Houssin		<regis.houssin@inodbox.com>
 * Copyright (C) 2010-2012	Laurent Destailleur	<eldy@users.sourceforge.net>
 * Copyright (C) 2012		Christophe Battarel	<christophe.battarel@altairis.fr>
 * Copyright (C) 2012       Cédric Salvador     <csalvador@gpcsolutions.fr>
 * Copyright (C) 2012-2014  Raphaël Doursenaud  <rdoursenaud@gpcsolutions.fr>
 * Copyright (C) 2013		Florian Henry		<florian.henry@open-concept.pro>
 * Copyright (C) 2018       Frédéric France         <frederic.france@netlogic.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 *
 * Need to have following variables defined:
 * $object (invoice, order, ...)
 * $conf
 * $langs
 * $seller, $buyer
 * $dateSelector
 * $forceall (0 by default, 1 for supplier invoices/orders)
 * $senderissupplier (0 by default, 1 for supplier invoices/orders)
 * $inputalsopricewithtax (0 by default, 1 to also show column with unit price including tax)
 */

// Protection to avoid direct call of template
if (empty($object) || ! is_object($object))
{
	print "Error, template page can't be called as URL";
	exit;
}

if (empty($conf->global->DOLITOOLS_USE_ALTATPL)) return;

if ( ! in_array($object->element, array('propal','supplier_proposal','facture','facturerec','invoice','commande','order','order_supplier','invoice_supplier')) ) return;

global $drafteditable;
$drafteditable = $drafteditable && in_array($object->element, array('facture','propal','commande'));

$usemargins=0;
if (! empty($conf->margin->enabled) && ! empty($object->element) && in_array($object->element, array('facture','facturerec','propal','commande'))) $usemargins=1;

// recalcul marge (en particulier pour location
if ($line->total_ht < 0)
	$marge = -1 * (abs($line->total_ht) - (abs($line->pa_ht) * $line->qty));
else
	$marge = $line->total_ht - ($line->pa_ht * $line->qty);

// calcul taux marge
if ($line->pa_ht != 0)
	$line->marge_tx = (100 * $marge) / $line->pa_ht;
// calcul taux marque
if ($line->total_ht != 0)
	$line->marque_tx = (100 * $marge) / $line->total_ht;

$showmargins = $usemargins; // && (empty($conf->rental->enabled) || empty($object->array_options['options_rental_doc']));

global $forceall, $senderissupplier, $inputalsopricewithtax;
if (empty($dateSelector)) $dateSelector=0;
if (empty($forceall)) $forceall=0;
if (empty($senderissupplier)) $senderissupplier=0;
if (empty($inputalsopricewithtax)) $inputalsopricewithtax=0;

// get stock infos
if (! empty($conf->global->ALTATPL_STOCK_ON_LINES) && $line->fk_product > 0 && empty($senderissupplier))
{
	include_once __DIR__ . '/../../lib/availablestock.lib.php';
	$stock_available = get_stock_for_line($line->fk_product, $line->array_options);
}

if ($i > 0)
{
	if ( ! $drafteditable )
	{
	?>
		<!-- BEGIN PHP TEMPLATE objectline_create.tpl.php -->
		</table>
		<table class="noborder noshadow centpercent" id="editline">
		<?php
		// ligne de titre pour saisie nouvelle ligne
		$editlinetitle = true; // important for objectline_title.tpl.php
		$parameters = array('createlinetitle'=>true, 'num'=>$num,'i'=>$i,'dateSelector'=>$dateSelector,'seller'=>$seller,'buyer'=>$buyer,'selected'=>$selected, 'extrafieldsline'=>$extrafieldsline, 'usemargins'=>$showmargins, 'lineedit_title'=>1);
		$reshook = $hookmanager->executeHooks('printObjectLineTitle', $parameters, $object, $action);
		if (empty($reshook))
		{
			// Output template part (modules that overwrite templates must declare this into descriptor)
			// Use global variables + $dateSelector + $seller and $buyer
			$dirtpls=array_merge($conf->modules_parts['tpl'], array($defaulttpldir));
			foreach($dirtpls as $module => $reldir)
			{
				if (!empty($module))
				{
					$tpl = dol_buildpath($reldir.'/objectline_title.tpl.php');
				}
				else
				{
					$tpl = DOL_DOCUMENT_ROOT.$reldir.'/objectline_title.tpl.php';
				}
				if (empty($conf->file->strict_mode)) {
					$res=@include $tpl;
				} else {
					$res=include $tpl; // for debug
				}
				if ($res) break;
			}
		}
	}
}

// Define colspan for the button 'Add'
$colspan = 2;	// col edit + col delete
if ( ! $drafteditable && in_array($object->element, array('propal','supplier_proposal','facture','facturerec','invoice','commande','order','order_supplier','invoice_supplier'))) $colspan++;	// With this, there is a column move button
?>

<!-- BEGIN PHP TEMPLATE objectline_edit.tpl.php -->

<?php
$coldisplay=0;

$suffix = '';
if ($drafteditable) $suffix = '_'.$line->id;

print '<tr id="row-'.$line->id.'" class="oddeven';

	if (! $drafteditable)
	{
		print ' tredited';
	}
	else
	{
		print ' drag drop '.($line->array_options['options_rental_line']?'rental':'sale');
	}
	print '"';

	if ($drafteditable) echo $domData;

	print '>';

	if ( $object->brouillon && ! empty($conf->global->DOLITOOLS_USE_DELETELINES) && $action != 'editline')
	{
		print '<td align="center"><input name="sel_'.$line->id.'" type="checkbox"';
		if (GETPOST("sel_".$line->id)) print ' checked="checked"';
		$coldisplay++;
		print ' /></td>';
	}
	?>

	<?php if (! empty($conf->global->MAIN_VIEW_LINE_NUMBER)) { ?>
		<td class="linecolnum center">
		<?php $coldisplay++; ?>
		<input type="text" id="rank<?php echo $suffix; ?>" name="rank<?php echo $suffix; ?>" size="1" value="<?php echo $line->rang; ?>" style="text-align:right" /></td>
	<?php }

	$coldisplay++;
	?>
	<td class="linecoldescription minwidth300imp">
	<div id="line_<?php echo $line->id; ?>"></div>

	<input type="hidden" id="lineid<?php echo $suffix; ?>" name="lineid<?php echo $suffix; ?>" value="<?php echo $line->id; ?>">
	<input type="hidden" id="product_type<?php echo $suffix; ?>" name="type<?php echo $suffix; ?>" value="<?php echo $line->product_type; ?>">
	<input type="hidden" id="stock_available<?php echo $suffix; ?>" name="stock_available<?php echo $suffix; ?>" value="<?php echo $stock_available; ?>">
	<input type="hidden" id="product_id<?php echo $suffix; ?>" name="productid<?php echo $suffix; ?>" value="<?php echo (! empty($line->fk_product)?$line->fk_product:0); ?>" />
	<input type="hidden" id="special_code<?php echo $suffix; ?>" name="special_code<?php echo $suffix; ?>" value="<?php echo $line->special_code; ?>">
	<input type="hidden" id="fk_parent_line<?php echo $suffix; ?>" name="fk_parent_line<?php echo $suffix; ?>" value="<?php echo $line->fk_parent_line; ?>">

	<?php
	global $db;
	require_once DOL_DOCUMENT_ROOT.'/product/class/product.class.php';
	$product = new Product($db);
	$product->fetch($line->fk_product);
	?>
	<input type="hidden" id="onpurchase<?php echo $suffix; ?>" name="onpurchase<?php echo $suffix; ?>" value="<?php echo $product->status_buy; ?>">
	<?php

	if ($line->fk_product > 0) { ?>

		<?php
		if ($line->fk_parent_line > 0) echo img_picto('', 'rightarrow');
		?>
		<a href="<?php echo DOL_URL_ROOT.'/product/card.php?id='.$line->fk_product; ?>">
		<?php
		if ($line->product_type==1) echo img_object($langs->trans('ShowService'), 'service');
		else print img_object($langs->trans('ShowProduct'), 'product');
		echo ' '.$line->ref;
		?>
		</a>
		<?php
		//Commented by Christophe Battarelif ( ! empty($conf->occasions->enabled) && ! empty($line->array_options['options_used_line']) )
		//Commented by Christophe Battarel{
			//Commented by Christophe Battarel$langs->load('occasions@occasions');
			//Commented by Christophe Battarelecho $langs->trans('ConditionUsed');
		//Commented by Christophe Battarel}
		if (empty($conf->global->DOLITOOLS_AVOID_LABEL_UPDATE))
		{
			if (!empty($line->label))
			{
				$label = $line->label;
			}
			else $label = $line->product_label;

			echo '<div style="display:inline; padding: 4px 4px; background-color: #fff; border: 1px #ccc solid;" contenteditable name="div_product_label'.$suffix.'">'.$label.'</div>';
			echo '<input type="hidden" name="product_label'.$suffix.'" value="'.dol_escape_js($label).'" />';
			echo '<input type="hidden" name="update_label'.$suffix.'" value="1" />';
		}
		else
		{
			if (!empty($line->label))// && !empty($line->array_options['options_rental_line']))
			{
				echo ' - '.nl2br($line->label);

				if (!empty($line->array_options['options_rental_line']))
				{
					echo '<input type="hidden" name="product_label'.$suffix.'" value="'.addslashes($line->label).'" />';
					echo '<input type="hidden" name="update_label'.$suffix.'" value="1" />';
				}
			}
			else echo ' - '.nl2br($line->product_label);
		}

		?>

		<br><br>

	<?php }	?>

	<?php
	if (is_object($hookmanager))
	{
		$fk_parent_line = (GETPOST('fk_parent_line') ? GETPOST('fk_parent_line') : $line->fk_parent_line);
	    $parameters=array('line'=>$line,'fk_parent_line'=>$fk_parent_line,'var'=>$var,'dateSelector'=>$dateSelector,'seller'=>$seller,'buyer'=>$buyer);
	    $reshook=$hookmanager->executeHooks('formEditProductOptions', $parameters, $object, $action);
	}

	// Do not allow editing during a situation cycle
	if ($line->fk_prev_id == null )
	{
		// editeur wysiwyg
		require_once DOL_DOCUMENT_ROOT.'/core/class/doleditor.class.php';
		$nbrows=ROWS_2;
		if (! empty($conf->global->MAIN_INPUT_DESC_HEIGHT)) $nbrows=$conf->global->MAIN_INPUT_DESC_HEIGHT;
		$enable=(isset($conf->global->FCKEDITOR_ENABLE_DETAILS)?$conf->global->FCKEDITOR_ENABLE_DETAILS:0);
		$toolbarname='dolibarr_details';
		if (! empty($conf->global->FCKEDITOR_ENABLE_DETAILS_FULL)) $toolbarname='dolibarr_notes';
		$doleditor=new DolEditor('product_desc'.$suffix, $line->description, '', (empty($conf->global->MAIN_DOLEDITOR_HEIGHT)?164:$conf->global->MAIN_DOLEDITOR_HEIGHT), $toolbarname, '', false, true, $enable, $nbrows, '98%');
		$doleditor->Create();
	} else {
		print '<textarea id="product_desc'.$suffix.'" class="flat" name="product_desc'.$suffix.'" readonly style="width: 200px; height:80px;">' . $line->description . '</textarea>';
	}

	// Show autofill date for recuring invoices
	if (! empty($conf->service->enabled) && $line->product_type == 1 && $line->element == 'facturedetrec')
	{
		echo '<br>';
		echo $langs->trans('AutoFillDateFrom').' ';
		echo $form->selectyesno('date_start_fill'.$suffix, $line->date_start_fill, 1);
		echo ' - ';
		echo $langs->trans('AutoFillDateTo').' ';
		echo $form->selectyesno('date_end_fill'.$suffix, $line->date_end_fill, 1);
	}

	?>
	</td>

	<?php
	if  (empty($conf->global->ALTATPL_HIDE_REF_FOURN) && ($object->element == 'supplier_proposal' || $object->element == 'order_supplier' || $object->element == 'invoice_supplier'))	{
	    $coldisplay++;
	?>
		<td class="nowrap"><input id="fourn_ref<?php echo $suffix; ?>" name="fourn_ref<?php echo $suffix; ?>" class="flat minwidth50 maxwidth150" value="<?php echo ($line->ref_supplier ? $line->ref_supplier : $line->ref_fourn); ?>"></td>
	<?php
	}
	?>

	<td class="right"><?php $coldisplay++; ?>
	<?php if (($line->info_bits & 2) != 2) {
		// I comment this because it shows info even when not required
		// for example always visible on invoice but must be visible only if stock module on and stock decrease option is on invoice validation and status is not validated
		// must also not be output for most entities (proposal, intervention, ...)
		//if($line->qty > $line->stock) print img_picto($langs->trans("StockTooLow"),"warning", 'style="vertical-align: bottom;"')." ";
		print '<input size="1" type="text" class="flat right" name="qty'.$suffix.'" id="qty'.$suffix.'" value="' . $line->qty . '"';
		if ($line->fk_prev_id != null ) print ' readonly';
		print '>';
	} else { ?>
		&nbsp;
	<?php } ?>
	</td>

	<?php
	if($conf->global->PRODUCT_USE_UNITS)
	{
	    $coldisplay++;
		print '<td class="left">';
		print $form->selectUnits($line->fk_unit, "units".$suffix, 0);
		print '</td>';
	}

	// Stock infos
	if (! empty($conf->stock->enabled) && ! empty($conf->global->ALTATPL_STOCK_ON_LINES) && empty($senderissupplier))
	{
		print '<td class="nowrap"><div class="dispo">';

		if ($line->fk_product > 0)
		{
			if (empty($line->array_options['options_rental_line']))
			{
				$stockLink = dol_buildpath('/product/stock/product.php',1).'?id='.$line->fk_product;
				print '<div class="stock_reel disponibilite"><a href="'.$stockLink.'" tabindex="-1" target="_blank" title="'.htmlspecialchars($langs->transnoentities(!empty($conf->global->USE_AVAILABLE_STOCK)?"AvailableStockDetails":"RealStock"), ENT_QUOTES).' : '.$stock_available.'">'.$stock_available.'</a></div>';
			}
			else
			{
				print '<a class="show_dispo" href="#" onclick="return showProductRentalInfos(\'row-'.$line->id.'\','.$line->fk_product.');">'.$langs->trans("Show").'</a>';
			}
		}
		print '</div></td>';
		$coldisplay++;
	}

	// for v11
	if (empty($extrafieldsline) && ! empty($extrafields)) $extrafieldsline = $extrafields;
	// end v11

	// hook to complete line with other cells
	$parameters = array('line'=>$line,'var'=>$var,'num'=>$num,'i'=>$i,'dateSelector'=>$dateSelector,'seller'=>$seller,'buyer'=>$buyer,'selected'=>$selected, 'extrafieldsline'=>$extrafieldsline);
	$reshook = $hookmanager->executeHooks('altatpl_completeObjectLine', $parameters, $object, $action);    // Note that $action and $object may have been modified by some hooks
	if (! empty($reshook)) { print '</tr>'; exit; }

	if (!empty($extrafieldsline) && ! empty($conf->global->ALTATPL_EXTRAFIELDS_IN_COLUMNS))
	{
		include_once __DIR__ . '/../../lib/altatpl.lib.php';
		$coldisplay += altatpl_showOptionalsValues($line, $extrafieldsline, 'edit', $line->array_options['options_rental_line'], null, $suffix);
	}

	$coldisplay++;
	print '<td class="right"><input type="text" class="flat right" size="5" id="price_ht'.$suffix.'" name="price_ht'.$suffix.'" value="' . (isset($line->pu_ht)?price($line->pu_ht, 0, '', 0):price($line->subprice, 0, '', 0)) . '"';
	if ($line->fk_prev_id != null) print ' readonly';
	print '></td>';

	if (!empty($conf->multicurrency->enabled) && $object->multicurrency_code != $conf->currency) {
	    $coldisplay++;
		print '<td class="right"><input rel="'.$object->multicurrency_tx.'" type="text" class="flat right" size="5" id="multicurrency_subprice'.$suffix.'" name="multicurrency_subprice'.$suffix.'" value="'.price($line->multicurrency_subprice).'" /></td>';
	}

	$coldisplay++;
	if ($line->fk_prev_id == null) {
		print '<td class="right">' . $form->load_tva('tva_tx'.$suffix.'', $line->tva_tx.($line->vat_src_code?(' ('.$line->vat_src_code.')'):''), $seller, $buyer, 0, $line->info_bits, $line->product_type, false, 0) . '</td>';
	} else {
		print '<td class="right"><input size="1" type="text" class="flat right" name="tva_tx'.$suffix.'" value="' . price($line->tva_tx) . '" readonly />%</td>';
	}

	if ( ! empty($conf->global->ALTATPL_SHOW_TTCPRICE))
	{
		$coldisplay++;
		print '<td class="right"><input type="text" class="flat right" size="5" id="price_ttc'.$suffix.'" name="price_ttc'.$suffix.'" value="'.(isset($line->pu_ttc)?price($line->pu_ttc, 0, '', 0):'').'"';
		if ($line->fk_prev_id != null) print ' readonly';
		print '></td>';
	}
	?>

	<td class="nowrap right"><?php $coldisplay++; ?>
	<?php if (($line->info_bits & 2) != 2) {
		print '<input size="1" type="text" class="flat right" name="remise_percent'.$suffix.'" id="remise_percent'.$suffix.'" value="' . $line->remise_percent . '"';
		if ($line->fk_prev_id != null ) print ' readonly';
		print '>%';
	} else { ?>
		&nbsp;
	<?php } ?>
	</td>
	<?php
	// discounted price TODO : remove rental stuff
	if (!empty($conf->global->ALTATPL_SHOW_DISCOUNTEDPRICE))
	{
		$coldisplay++;
		$pxrem = $line->subprice * (1 - $line->remise_percent / 100) + ($line->array_options['options_rental_warranty_price']?$line->array_options['options_rental_warranty_price'] * $line->remise_percent / 100:0);
		print '<td class="right"><input type="text" class="flat right" size="5" id="discounted_price'.$suffix.'" name="discounted_price'.$suffix.'" value="'.(isset($pxrem)?price($pxrem, 0, '', 0):'').'"';
		if ($line->fk_prev_id != null) print ' readonly';
		print '></td>';
	}
	if ($object->situation_cycle_ref) {
		$coldisplay++;
		print '<td class="nowrap right linecolcycleref"><input class="right" type="text" size="1" value="' . $line->situation_percent . '" name="progress'.$suffix.'">%</td>';
		$coldisplay++;
		print '<td></td>';
	}
	if (! empty($showmargins))
	{
        if (!empty($user->rights->margins->creer))
        {
            $coldisplay++;
        ?>
        <td class="margininfos right">
			<!-- For predef product -->
			<?php if (! empty($conf->product->enabled) || ! empty($conf->service->enabled)) { ?>
			<select id="fournprice_predef<?php echo $suffix; ?>" name="fournprice_predef<?php echo $suffix; ?>" class="flat right" style="display: none;"></select>
			<?php } ?>
			<!-- For free product -->
			<input class="flat right" type="text" size="5" id="buying_price<?php echo $suffix; ?>" name="buying_price<?php echo $suffix; ?>" class="hideobject" value="<?php echo price($line->pa_ht, 0, '', 0); ?>">
		</td>
		<?php }

        if ($user->rights->margins->creer) {
			if (! empty($conf->global->DISPLAY_MARGIN_RATES))
			{
				$margin_rate = (isset($_POST["np_marginRate"])?GETPOST("np_marginRate", "alpha", 2):(($line->pa_ht == 0)?'':price($line->marge_tx)));
				// if credit note, dont allow to modify margin
				if ($line->subprice < 0)
					echo '<td class="right nowrap margininfos">'.$margin_rate.'<span class="hideonsmartphone">%</span></td>';
				else
					echo '<td class="right nowrap margininfos"><input class="right" type="text" size="2" name="np_marginRate'.$suffix.'" value="'.$margin_rate.'"><span class="hideonsmartphone">%</span></td>';
				$coldisplay++;
			}
			if (! empty($conf->global->DISPLAY_MARK_RATES))
			{
				$mark_rate = (isset($_POST["np_markRate"])?GETPOST("np_markRate", 'alpha', 2):price($line->marque_tx));
				// if credit note, dont allow to modify margin
				if ($line->subprice < 0)
					echo '<td class="right nowrap margininfos">'.$mark_rate.'<span class="hideonsmartphone">%</span></td>';
				else
					echo '<td class="right nowrap margininfos"><input class="right" type="text" size="2" name="np_markRate'.$suffix.'" value="'.$mark_rate.'"><span class="hideonsmartphone">%</span></td>';
				$coldisplay++;
			}
		}
	}
	if (! $drafteditable)
	{
?>
	<!-- colspan for this td because it replace total_ht+3 td for buttons+... -->
	<td class="center valignmiddle" colspan="<?php echo $colspan; ?>"><?php $coldisplay+=$colspan; ?>
			<input type="submit" class="button" id="savelinebutton" name="save" value="<?php echo $langs->trans("Save"); ?>"><br>
			<input type="submit" class="button" id="cancellinebutton" name="cancel" value="<?php echo $langs->trans("Cancel"); ?>">
	</td>
	<?php
	}
	else
	{
	?>

	<?php if ($line->special_code == 3)	{
		$optionspan = 1;
		if (!empty($conf->multicurrency->enabled) && $object->multicurrency_code != $conf->currency) $optionspan++;
		if ($outputalsopricetotalwithtax) $optionspan++;
	?>
		<td class="linecoloption nowrap right" colspan="<?php echo $optionspan; ?>"><?php $coldisplay+=$optionspan; ?><?php echo $langs->trans('Option'); ?></td>
	<?php } else { ?>
		<td class="linecolht nowrap right"><?php
		  $coldisplay++;
		  if (empty($conf->global->MAIN_OPTIMIZEFORTEXTBROWSER))
		  {
    		  print '<span class="classfortooltip" title="';
    		  print $langs->transcountry("TotalHT", $mysoc->country_code).'='.price($line->total_ht);
    		  print '<br>'.$langs->transcountry("TotalVAT", ($senderissupplier?$object->thirdparty->country_code:$mysoc->country_code)).'='.price($line->total_tva);
    		  if (price2num($line->total_localtax1)) print '<br>'.$langs->transcountry("TotalLT1", ($senderissupplier?$object->thirdparty->country_code:$mysoc->country_code)).'='.price($line->total_localtax1);
    		  if (price2num($line->total_localtax2)) print '<br>'.$langs->transcountry("TotalLT2", ($senderissupplier?$object->thirdparty->country_code:$mysoc->country_code)).'='.price($line->total_localtax2);
    		  print '<br>'.$langs->transcountry("TotalTTC", $mysoc->country_code).'='.price($line->total_ttc);
    		  print '">';
		  }
		  print price($line->total_ht);
		  if (empty($conf->global->MAIN_OPTIMIZEFORTEXTBROWSER))
		  {
		      print '</span>';
		  }
		  ?>
		</td>
		<?php
		if (!empty($conf->multicurrency->enabled) && $object->multicurrency_code != $conf->currency) { ?>
			<td class="linecolutotalht_currency nowrap right"><?php $coldisplay++; ?><?php echo price($line->multicurrency_total_ht); ?></td>
		<?php
		}
		if ($outputalsopricetotalwithtax)
		{
		?>
			<td class="linecolttc nowrap right"><?php $coldisplay++; ?><?php echo price($line->total_ttc); ?></td>
		<?php
		}
		?>
	<?php
	}
	?>

		<td class="linecoladd center"><?php $coldisplay++; ?>
	<?php
		print '<a class="addline '.($line->array_options['options_rental_line']?'rental':'sale').'" href="#" onclick="addline(this); return false">';
		print '<span class="addline">'.img_edit_add().'</span>';
		print '</a>';
	?>
		</td>
		<td class="linecoldelete center"><?php $coldisplay++; ?>
			<?php
			// commented by christophe battarelif (($line->fk_prev_id == null ) && empty($disableremove)) { //La suppression n'est autorisée que si il n'y a pas de ligne dans une précédente situation
				print '<div class="restore_line" style="display: none;">'.$langs->trans("LineDeleted").'</div>';
				print '<a class="delete" href="#" onclick="toggle_line(this); return false">';
				print '<span class="delete_line">'.img_delete().'</span>';
				print '<div class="restore_line" style="display: none;">'.$langs->trans("Restore").'</div>';
				print '</a>';
			// commented by christophe battarel}
			?>
		</td>
		<?php
		if ($num > 1 && $conf->browser->layout != 'phone' && ($object->situation_counter == 1 || !$object->situation_cycle_ref) && empty($disablemove)) { ?>
		<td class="linecolmove tdlineupdown center"><?php $coldisplay++; ?>
			<?php if ($i > 0) { ?>
			<a class="lineupdown" href="<?php echo $_SERVER["PHP_SELF"].'?id='.$object->id.'&amp;action=up&amp;rowid='.$line->id; ?>">
			<?php echo img_up('default', 0, 'imgupforline'); ?>
			</a>
			<?php } ?>
			<?php if ($i < $num-1) { ?>
			<a class="lineupdown" href="<?php echo $_SERVER["PHP_SELF"].'?id='.$object->id.'&amp;action=down&amp;rowid='.$line->id; ?>">
			<?php echo img_down('default', 0, 'imgdownforline'); ?>
			</a>
			<?php } ?>
		</td>
	    <?php } else { ?>
	    <td <?php echo (($conf->browser->layout != 'phone' && empty($disablemove)) ?' class="linecolmove tdlineupdown center"':' class="linecolmove center"'); ?>><?php $coldisplay++; ?></td>
		<?php } ?>
	<?php
    }
	?>
</tr>

<?php
//Line extrafield
if (!empty($extrafieldsline) && empty($conf->global->ALTATPL_EXTRAFIELDS_IN_COLUMNS))
{
	print $line->showOptionals($extrafieldsline, 'edit', array('class'=>'tredited', 'colspan'=>$coldisplay), $suffix, '', 0);
}
?>

<?php if (! empty($conf->service->enabled) && $line->product_type == 1 && $dateSelector)	 { ?>
<tr id="service_duration_area" class="treditedlinefordate">
	<?php if (! empty($conf->global->MAIN_VIEW_LINE_NUMBER)) { ?>
		<td class="linecolnum center"></td>
	<?php } ?>
	<td colspan="<?php echo $coldisplay; ?>"><?php echo $langs->trans('ServiceLimitedDuration').' '.$langs->trans('From').' '; ?>
	<?php
	$hourmin=(isset($conf->global->MAIN_USE_HOURMIN_IN_DATE_RANGE)?$conf->global->MAIN_USE_HOURMIN_IN_DATE_RANGE:'');
	print $form->selectDate($line->date_start, 'date_start'.$suffix, $hourmin, $hourmin, $line->date_start?0:1, "updateline", 1, 0);
	print ' '.$langs->trans('to').' ';
	print $form->selectDate($line->date_end, 'date_end'.$suffix, $hourmin, $hourmin, $line->date_end?0:1, "updateline", 1, 0);
	print '<script type="text/javascript">';
	if (!$line->date_start) {
		if (isset($conf->global->MAIN_DEFAULT_DATE_START_HOUR)) {
			print '$("#date_starthour'.$suffix.'").val("'.$conf->global->MAIN_DEFAULT_DATE_START_HOUR.'");';
		}
		if (isset($conf->global->MAIN_DEFAULT_DATE_START_MIN)) {
			print '$("#date_startmin'.$suffix.'").val("'.$conf->global->MAIN_DEFAULT_DATE_START_MIN.'");';
		}
	}
	if (!$line->date_end) {
		if (isset($conf->global->MAIN_DEFAULT_DATE_END_HOUR)) {
			print '$("#date_endhour'.$suffix.'").val("'.$conf->global->MAIN_DEFAULT_DATE_END_HOUR.'");';
		}
		if (isset($conf->global->MAIN_DEFAULT_DATE_END_MIN)) {
			print '$("#date_endmin'.$suffix.'").val("'.$conf->global->MAIN_DEFAULT_DATE_END_MIN.'");';
		}
	}
	print '</script>'
	?>
	</td>
</tr>
<?php }

// javascript pour edit et ajout ligne
require_once __DIR__ . '/objectline_edit_once.tpl.php';
