<?php
/* Copyright (C) 2019	Christophe Battarel	<christophe.battarel@altairis.fr>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

/**
 *  \file       htdocs/custom/dolitools/class/actions_dolitools.php
 *  \ingroup    dolitools
 *  \brief      actions for dolitools module (hook)
 */

class ActionsDolitools// extends CommonObject
{

	function __construct()
	{
		global $db, $conf, $drafteditable, $action;

		$this->db = $db;

		$drafteditable = ! empty($conf->global->DOLITOOLS_USE_ALTATPL) && ! empty($conf->global->DOLITOOLS_DRAFT_EDITABLE) && ( ( ! empty($conf->global->DOLITOOLS_DRAFT_ALWAYS_EDITABLE) && empty($action)) || $action == 'draftedit' || $action == 'draftupdate' );

		if ($drafteditable)
			$conf->global->SUBTOTAL_ALLOW_ADD_BLOCK = 0; // pour eviter boutons sous-total

	}

	function doActions($parameters,$object,&$action)
	{
		global $conf, $drafteditable;

		if ( ! empty($conf->global->DOLITOOLS_USE_ALTATPL) && ! empty($conf->global->DOLITOOLS_USE_DELETELINES) ) include_once(__DIR__.'/deletelines/doactions.inc.php');

		if ( ! empty($conf->global->DOLITOOLS_USE_UPDATELINES)) include_once(__DIR__.'/updatelines/doactions.inc.php');

		if ( ! empty($conf->global->DOLITOOLS_USE_CUSTOMREF)) include_once(__DIR__.'/customref/doactions.inc.php');

		if ( ! empty($conf->global->USE_AVAILABLE_STOCK)) include_once(__DIR__.'/availablestock/doactions.inc.php');

		if ( $drafteditable ) include_once(__DIR__.'/drafts/doactions.inc.php');

		return 0;
	}

	function formObjectOptions($parameters,$object,&$action)
	{
		global $conf, $drafteditable;

		if ( ! $drafteditable ) include_once(__DIR__.'/drafts/formobjectoptions.inc.php');

		if ( ! empty($conf->subtotal->enabled)) include_once(__DIR__.'/subtotal/formobjectoptions.inc.php');

		if ( ! empty($conf->global->DOLITOOLS_USE_ALTATPL) && ! empty($conf->global->DOLITOOLS_USE_DELETELINES) ) include_once(__DIR__.'/deletelines/formobjectoptions.inc.php');

		if ( ! empty($conf->global->DOLITOOLS_USE_ALTATPL)) include_once(__DIR__.'/altatpl/formobjectoptions.inc.php');

		if ( ! empty($conf->global->DOLITOOLS_USE_CUSTOMREF)) include_once(__DIR__.'/customref/formobjectoptions.inc.php');

		if ( ! empty($conf->global->USE_AVAILABLE_STOCK)) include_once(__DIR__.'/availablestock/formobjectoptions.inc.php');

		if ( ! empty($conf->global->THIRD_PRIVATE_NOTES_ON_CARDS)) include_once(__DIR__.'/cards/formobjectoptions.inc.php');

	}


	function createFrom($parameters,$object,&$action)
	{
		global $conf;

		if ( ! empty($conf->global->DOLITOOLS_CHECK_ON_CLONE)) include_once(__DIR__.'/checkonclone/createfrom.inc.php');

	}


    function formConfirm($parameters, $object, &$action)
    {
		global $conf, $langs, $form;

		if ($action != 'clone') return; // action seemes to be blank but not this->action...

		if ( empty($conf->global->DOLITOOLS_USE_CUSTOMREF) && empty($conf->global->DOLITOOLS_CHECK_ON_CLONE)) return 0;

  		$element = $object->element;

		// TODO uniformiser
		if ($element == 'propal') $element = 'propale';

		$sep = $conf->global->CUSTOMREF_SEPARATOR?$conf->global->CUSTOMREF_SEPARATOR:'';
		$lensep = mb_strlen($sep);

		if ($element == 'propale' || $element=='commande' || $element == 'facture')
		{
			$this->resprints = '';
			$jsconfirm = '';

			// Create an array for form
			$formquestion=array();

			$formquestion[] = array('type' => 'other', 'name' => 'socid',   'label' => $langs->trans("SelectThirdParty"),   'value' => $form->select_company(GETPOST('socid','int'),'socid','(s.client=1 OR s.client=2 OR s.client=3)'));

			if ( ! empty($conf->global->DOLITOOLS_USE_CUSTOMREF)) include_once(__DIR__.'/customref/formconfirm.inc.php');

			if ( ! empty($conf->global->DOLITOOLS_CHECK_ON_CLONE)) include_once(__DIR__.'/checkonclone/formconfirm.inc.php');

			if (!empty($conf->global->PROPAL_CLONE_DATE_DELIVERY) && !empty($object->date_livraison)) {
				$formquestion[] = array('type' => 'date','name' => 'date_delivery','label' => $langs->trans("DeliveryDate"),'value' => $object->date_livraison);
			}

			$this->resprints .= '<script type="text/javascript">
				$(document).ready(function() {
					$("#dialog-confirm").bind("dialogcreate", function (event, ui)
					{
						var buttons = $("#dialog-confirm").dialog("option", "buttons");
						var func = buttons["'.dol_escape_js($langs->transnoentities("Yes")).'"];

						var ok;

						buttons["'.dol_escape_js($langs->transnoentities("Yes")).'"] = function(e) { ok = true;};
						$("#dialog-confirm").dialog("option", "buttons", buttons);
					'
						.$jsconfirm.'
						$("div.ui-dialog-buttonset button:first").click(function(e) {
							setTimeout(function() { if (ok) { func(); } }, 500); // in case included js has ajax request (ie customref)
						});
					});
				});
			</script>';

			// choix client et ref
			$this->resprints .= $form->formconfirm($_SERVER["PHP_SELF"].'?id='.$object->id,$langs->trans('ToClone'),$langs->trans('ConfirmClone'.$msg,$object->ref),'confirm_clone',$formquestion,'yes',1,'auto','auto');

			return 1;
		}

		return 0;
	}

	function addMoreActionsButtons($parameters, $object, &$action)
    {
		global $conf, $drafteditable;

		if ( ! empty($conf->global->DOLITOOLS_DRAFT_EDITABLE) )
		{
			include_once(__DIR__.'/drafts/addmoreactionsbuttons.inc.php');

			if ($drafteditable)
			{
				return 1;
			}
		}

		if ( ! empty($conf->global->DOLITOOLS_USE_UPDATELINES)) include_once(__DIR__.'/updatelines/addmoreactionsbuttons.inc.php');


		return 0;
	}

    function formAddObjectLine($parameters, $object, $action)
    {
		global $conf;

		if ( ! empty($conf->global->DOLITOOLS_USE_ALTATPL)) include_once(__DIR__.'/altatpl/formaddobjectline.inc.php');

		return 0;
	}

	function printTopRightMenu($parameters)
	{
		global $langs, $conf;

		$langs->load("dolitools@dolitools");

		$this->resprints = "";

		$conf->global->MAIN_HTML_FOOTER .='<script src="'.dol_buildpath("/dolitools/js/jquery.tableToExcel.js", 1).'"></script>

				<script type="text/javascript">
					function cleantable(table)
					{
						$("thead:first, tbody:first", table).children("tr").children("td, th").each(function() {
							cleantd(this);
						});
					}
					function cleantd(td)
					{
						var tdval = "";
						var istable = false;

						$(td).children().each(function() {
							if (this.tagName == "TABLE") {
								cleantable(this);
								tdval += this.outerHTML;
								istable = true;
							}
							else if (this.tagName == "INPUT" && $(this).attr("type") == "checkbox") tdval += $(this).prop("checked")?"X":" ";
							else if (this.tagName == "INPUT") tdval += $(this).val();
							else if (this.tagName == "SELECT") tdval += $("option:selected", this).text();
						});

						if ( ! istable) $(td).html(tdval + $(td).text());
						else if (tdval != "") $(td).html(tdval);

						var str = $(td).html();
						var regex = /<br[^>]*>/gi;
						$(td).html(str.replace(regex, "\n"));

					}
					function excel(link) {

						var list_tables = $("table.liste").not(".formdoc");

						if ($(list_tables).length == 0) { alert("'.$langs->trans("NoListToExport").'"); return false; }

						$(list_tables).each(function() {
							var table = $(this).clone();

							// ménage
							$("script, dl, img, input[type=hidden], input[type=image], input[type=button], input[type=submit], button", table).remove();
							$("tr.liste_titre_filter", table).remove();
							$("tr.liste_titre", table).each(function() {if ($(this).find("td.filtre, select, input:not(:checkbox)").length > 0) $(this).remove();});

							cleantable(table);

							table.tblToExcel({ "anchor": link, "title": document.title});
						});
					}
				</script>';
		$text.='<a href="#" onclick="excel(this);">';
		$text.='<span id="excel" class="fa fa-file-excel atoplogin valignmiddle"></span>';
		$text.='</a>';

		$this->resprints .= @Form::textwithtooltip('', $langs->trans("ExcelExport"), 2, 1, $text, 'login_block_elem', 2);


		return 0;
	}
}
