<?php
/* Copyright (C) 2004-2017 Laurent Destailleur  <eldy@users.sourceforge.net>
 * Copyright (C) 2019 Alice Adminson
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

/**
 * \file    dolitools/admin/setup.php
 * \ingroup dolitools
 * \brief   Dolitools setup page.
 */

// Load Dolibarr environment
$res=0;
// Try main.inc.php into web root known defined into CONTEXT_DOCUMENT_ROOT (not always defined)
if (! $res && ! empty($_SERVER["CONTEXT_DOCUMENT_ROOT"])) $res=@include $_SERVER["CONTEXT_DOCUMENT_ROOT"]."/main.inc.php";
// Try main.inc.php into web root detected using web root calculated from SCRIPT_FILENAME
$tmp=empty($_SERVER['SCRIPT_FILENAME'])?'':$_SERVER['SCRIPT_FILENAME'];$tmp2=realpath(__FILE__); $i=strlen($tmp)-1; $j=strlen($tmp2)-1;
while($i > 0 && $j > 0 && isset($tmp[$i]) && isset($tmp2[$j]) && $tmp[$i]==$tmp2[$j]) { $i--; $j--; }
if (! $res && $i > 0 && file_exists(substr($tmp, 0, ($i+1))."/main.inc.php")) $res=@include substr($tmp, 0, ($i+1))."/main.inc.php";
if (! $res && $i > 0 && file_exists(dirname(substr($tmp, 0, ($i+1)))."/main.inc.php")) $res=@include dirname(substr($tmp, 0, ($i+1)))."/main.inc.php";
// Try main.inc.php using relative path
if (! $res && file_exists("../../main.inc.php")) $res=@include "../../main.inc.php";
if (! $res && file_exists("../../../main.inc.php")) $res=@include "../../../main.inc.php";
if (! $res) die("Include of main fails");

global $langs, $user;

// Libraries
require_once DOL_DOCUMENT_ROOT . "/core/lib/admin.lib.php";
require_once '../lib/dolitools.lib.php';
//require_once "../class/myclass.class.php";

// Translations
$langs->loadLangs(array("admin", "altatpl@dolitools", "dolitools@dolitools"));

// Access control
if (! $user->admin) accessforbidden();

// Parameters
$action = GETPOST('action', 'alpha');
$var = GETPOST('var', 'alpha');
$backtopage = GETPOST('backtopage', 'alpha');

$arrayofparameters=array(
	'ALTATPL_STOCK_ON_LINES',
	'DOLITOOLS_USE_DELETELINES',
	'ALTATPL_MODIFY_PRICES_ON_CREATE',
	'ALTATPL_SHOW_MARGIN_INFOS',
	'ALTATPL_FOURNREF_ON_PRICELIST',
	'ALTATPL_SHOW_DISCOUNTEDPRICE',
	'ALTATPL_SHOW_TTCPRICE',
	'MAIN_VIEW_LINE_NUMBER',
	'ALTATPL_HIDE_REF_FOURN',
	'ALTATPL_EXTRAFIELDS_IN_COLUMNS',
	'DOLITOOLS_DRAFT_EDITABLE'
);



/*
 * Actions
 */

if ($action == 'activate') dolibarr_set_const($db, $var, "1", 'chaine', 0, '', $conf->entity);
elseif ($action == 'disable') dolibarr_del_const($db, $var, $conf->entity);

/*
 * View
 */

$page_name = "DolitoolsSetup";
llxHeader('', $langs->trans($page_name));

// Subheader
$linkback = '<a href="'.($backtopage?$backtopage:DOL_URL_ROOT.'/admin/modules.php?restore_lastsearch_values=1').'">'.$langs->trans("BackToModuleList").'</a>';

print load_fiche_titre($langs->trans($page_name), $linkback, 'object_altairis@dolitools');

// Configuration header
$head = dolitoolsAdminPrepareHead();
dol_fiche_head($head, 'altatpl', '', -1, "dolitools@dolitools");

// Setup page goes here
echo '<span class="opacitymedium">'.$langs->trans("AltatplSetupPage").'</span><br><br>';

if (! empty($arrayofparameters))
{

	print '<table class="noborder" width="100%">';
	print '<tr class="liste_titre"><td >'.$langs->trans("Parameter").'</td><td>'.$langs->trans("Status").'</td><td>'.$langs->trans("Description").'</td></tr>';

	foreach($arrayofparameters as $key)
	{
		print '<tr class="oddeven">';
		print '<td>';
		print $langs->trans($key);
		print '</td>';
		print '<td>';
		if(empty($conf->global->$key))
		{
			print '<a href="'.$_SERVER['PHP_SELF'].'?action=activate&var='.$key.'">'.img_picto($langs->trans("Disabled"),'switch_off').'</a>';
		}
		else
		{
			print '<a href="'.$_SERVER['PHP_SELF'].'?action=disable&var='.$key.'">'.img_picto($langs->trans("Enabled"),'switch_on').'</a>';
		}
		print '</td>';
		print '<td>';
		print $langs->trans($key.'Desc');
		print '</td>';
		print '</tr>';
	}
	print '</table>';

	print '<br>';
}
else
{
	print '<br>'.$langs->trans("NothingToSetup");
}


// Page end
dol_fiche_end();

llxFooter();
$db->close();
