<?php

/* <one line to give the program's name and a brief idea of what it does.>
 * Copyright (C) 2012-2013 jacquel jerome <icfr.eirl@free.fr>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


/**
 * 	\file		new.php
 * 	\ingroup	echeancier
 * 	\brief		page de creation d'echeancier
 */
$res = 0;
if (!$res && file_exists("../main.inc.php")) {
    $res = @include("../main.inc.php");
}
if (!$res && file_exists("../../main.inc.php")) {
    $res = @include("../../main.inc.php");
}
if (!$res && file_exists("../../../main.inc.php")) {
    $res = @include("../../../main.inc.php");
}
$res = 0;
if (!$res && file_exists(DOL_DOCUMENT_ROOT . "/echeancier/class/echeancier_new.class.php"))
    $res = @include(DOL_DOCUMENT_ROOT . "/echeancier/class/echeancier_new.class.php");
if (!$res && file_exists("./class/echeancier.class.php"))
    $res = @include("./class/echeancier.class.php");
if (!$res)
    die("Include of echeancier class fails");


// Access control
if ($user->societe_id > 0 || !$user->rights->echeancier->facture) {
    // External user
    accessforbidden();
}


$societe = new Societe($db);


/*
 * ACTIONS
 *
 * Put here all code to do according to value of "action" parameter
 */



/*
 * VIEW
 *
 * Put here all code to build page
 */

llxHeader('', 'Echeancier', '');
print_fiche_titre($langs->trans("nouvelEchéancier"));
$echeancier = array();
$sql = "select id_element from " . MAIN_DB_PREFIX . "echeancier";
$result = $db->query($sql);
if ($result) {
    $num = $db->num_rows($result);
    $i = 0;
    while ($i < $num) {
        $objp = $db->fetch_object($result);

        $echeancier[$i] = $objp->id_element;

        $i++;
    }
}

$sql = "select * from " . MAIN_DB_PREFIX . "facture where fk_mode_reglement=(select id from " . MAIN_DB_PREFIX . "c_paiement where code='ECH' limit 1 )";
$result = $db->query($sql);

print '<table id="ticket" class="noborder" width="100%" >';
print '<thead><tr class="liste_titre"><th>' . $langs->trans('NumeroDeFacture') . '</th><th align="center">' . $langs->trans('name') . '</th><th align="center">' . $langs->trans('montantTtc') . '</th><th></th></tr></thead>'; //<th>' . $langs->trans('categorie') . '</th><th>' . $langs->trans('statut') . '</th><th width="210px">' . $langs->trans('assigné à') . '</th></tr></thead>';


if ($result) {
    $num = $db->num_rows($result);
    $i = 0;
    while ($i < $num) {
        $objp = $db->fetch_object($result);
        if (!in_array($objp->rowid, $echeancier)) {
            $societe->fetch($objp->fk_soc);

            $var = !$var;
            print '<form action="echeancier_facture.php" method="post">';
            print '<input type="hidden" name="action" value="create">';
            print '<input type="hidden" name="token" value="' . $_SESSION['newtoken'] . '">';
            print '<input type="hidden" name="id" value="' . $objp->rowid . '">';
            print '<input type="hidden" name="montant" value="' . $objp->total_ttc . '">';
            print '<input type="hidden" name="facture" value="' . $objp->facnumber . '">';
            print '<input type="hidden" name="id_client" value="' . $objp->fk_soc . '">';

            //facture
            if (DOL_VERSION < 6.0) {
                print '<tr ' . $bc[$var] . '><td ><a href="' . DOL_MAIN_URL_ROOT . '/compta/facture.php?facid=' . $objp->rowid . '">' . $objp->facnumber . '</a>';
            } else {
                print '<tr ' . $bc[$var] . '><td ><a href="' . DOL_MAIN_URL_ROOT . '/compta/facture/card.php?facid=' . $objp->rowid . '">' . $objp->facnumber . '</a>';
            }
            print "</td>";
            //societe
            print '<td align="center"><a href="' . DOL_MAIN_URL_ROOT . '/societe/soc.php?socid=' . $objp->fk_soc . '">' . $societe->nom . '</a></td>';
            //total
            print '<td align="center">' . number_format($objp->total_ttc, $conf->global->MAIN_MAX_DECIMALS_TOT) . '</td>';

            print '<td width="100px" align="right"><input type="submit" id="addelementbuton" class="button" value="' . $langs->trans("Créer") . '"></td>';
            print '</form></td></tr>';
        }





        $i++;
    }
}
print '</table>';

// End of page
llxFooter();
$db->close();